function mpc = Transmission_Network_PT_2030_Slow_Progression

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	1	2	0.000	0.000	0	0	1	1.0473	12.45	400	1	1.05	0.95	;
	2	2	0.000	0.000	0	0	1	1.0479	14.22	400	1	1.05	0.95	;
	3	2	0.000	0.000	0	0	1	1.0407	5.48	400	1	1.05	0.95	;
	4	2	0.000	0.000	0	0	1	1.0363	0.97	400	1	1.05	0.95	;
	5	2	0.000	0.000	0	0	1	1.0476	15.09	220	1	1.05	0.95	;
	6	2	0.000	0.000	0	0	1	1.0471	15.05	220	1	1.05	0.95	;
	7	2	0.000	0.000	0	0	1	1.0314	-4.42	400	1	1.05	0.95	;
	305	2	0.000	0.000	0	0	1	1.0442	10.45	400	1	1.05	0.95	;
	8	1	0.000	0.000	0	0	1	1.0055	-1.02	150	2	1.05	0.95	;
	9	1	0.000	0.000	0	0	1	1.0283	-5.24	150	2	1.05	0.95	;
	10	2	0.000	0.000	0	0	1	1.0341	-4.47	150	2	1.05	0.95	;
	11	1	3.968	-0.298	0	0	1	1.0197	-6.4	150	2	1.05	0.95	;
	12	1	0.000	0.000	0	0	1	1.017	-7.89	150	2	1.05	0.95	;
	13	1	5.953	2.083	0	0	1	1.0272	-5.62	150	2	1.05	0.95	;
	14	2	0.000	0.000	0	0	1	1.0296	-5.1	150	2	1.05	0.95	;
	15	1	0.000	0.000	0	0	1	1.035	-4.24	150	2	1.05	0.95	;
	16	1	0.000	0.000	0	0	1	1.021	10.09	150	2	1.05	0.95	;
	17	1	0.000	0.000	0	0	1	1.0257	9.19	150	2	1.05	0.95	;
	18	1	6.945	-0.893	0	0	1	1.0245	8.84	150	2	1.05	0.95	;
	19	1	0.000	0.000	0	0	1	1.0204	-6.6	150	2	1.05	0.95	;
	20	1	0.000	0.000	0	0	1	1.0247	-5.94	150	2	1.05	0.95	;
	21	1	0.000	0.000	0	0	1	1.0258	8.98	150	2	1.05	0.95	;
	22	2	0.000	0.000	0	0	1	1.0276	-6.02	150	2	1.05	0.95	;
	23	1	0.000	0.000	0	0	1	1.0131	-8.38	150	2	1.05	0.95	;
	24	2	0.000	0.000	0	0	1	1.0214	6.8	150	2	1.05	0.95	;
	25	1	0.000	0.000	0	0	1	1.0209	8.89	150	2	1.05	0.95	;
	26	1	3.968	0.099	0	0	1	1.0348	-4.43	150	2	1.05	0.95	;
	27	1	2.976	-0.198	0	0	1	1.033	-4.81	150	2	1.05	0.95	;
	28	1	1.984	-0.198	0	0	1	1.0288	-6.05	150	2	1.05	0.95	;
	29	2	0.000	0.000	0	0	1	1.024	-7	150	2	1.05	0.95	;
	30	2	0.000	0.000	0	0	1	1.0339	10.66	150	2	1.05	0.95	;
	31	1	0.000	0.000	0	0	1	1.0172	6.84	150	2	1.05	0.95	;
	32	1	0.000	0.000	0	0	1	1.0287	9.83	150	2	1.05	0.95	;
	33	1	0.000	0.000	0	0	1	1.0369	11.88	150	2	1.05	0.95	;
	34	2	0.000	0.000	0	-75	1	1.0289	-6.37	150	2	1.05	0.95	;
	36	1	0.000	0.000	0	0	1	1.0183	-0.91	220	2	1.05	0.95	;
	37	1	0.000	0.000	0	0	1	1.0231	-3.49	220	2	1.05	0.95	;
	38	1	0.000	0.000	0	0	1	1.0226	5.79	220	2	1.05	0.95	;
	39	1	0.000	0.000	0	0	1	1.0254	2.62	220	2	1.05	0.95	;
	40	1	0.000	0.000	0	0	1	1.0458	14	220	2	1.05	0.95	;
	41	1	0.000	0.000	0	0	1	1.0228	5.83	220	2	1.05	0.95	;
	42	1	0.000	0.000	0	0	1	1.0281	5.59	220	2	1.05	0.95	;
	43	1	0.000	0.000	0	0	1	1.0216	-3.79	220	2	1.05	0.95	;
	44	1	0.000	0.000	0	0	1	1.0215	5.49	220	2	1.05	0.95	;
	45	1	0.000	0.000	0	0	1	1.0244	-0.96	220	2	1.05	0.95	;
	46	1	0.000	0.000	0	0	1	1.0223	-2.28	220	2	1.05	0.95	;
	47	1	0.000	0.000	0	0	1	1.0284	7.44	220	2	1.05	0.95	;
	48	1	39.684	7.937	0	0	1	1.0242	4.67	220	2	1.05	0.95	;
	49	1	0.000	0.000	0	0	1	1.0199	5.68	220	2	1.05	0.95	;
	50	1	0.000	0.000	0	100	1	1.023	-3.26	220	2	1.05	0.95	;
	51	1	0.000	0.000	0	0	1	1.0358	11.4	220	2	1.05	0.95	;
	52	1	0.000	0.000	0	0	1	1.0245	1.13	220	2	1.05	0.95	;
	53	1	0.000	0.000	0	0	1	1.022	5.64	220	2	1.05	0.95	;
	54	1	0.000	0.000	0	0	1	1.0462	20.67	220	2	1.05	0.95	;
	55	1	0.000	0.000	0	0	1	1.0212	-3.9	220	2	1.05	0.95	;
	56	1	0.000	0.000	0	100	1	1.0231	-4.21	220	2	1.05	0.95	;
	57	1	0.000	0.000	0	0	1	1.0231	6.16	220	2	1.05	0.95	;
	58	1	0.000	0.000	0	0	1	1.021	-3.97	220	2	1.05	0.95	;
	59	1	0.000	0.000	0	0	1	1.0233	-3.62	220	2	1.05	0.95	;
	60	1	0.000	0.000	0	0	1	1.0295	7.5	220	2	1.05	0.95	;
	61	2	0.000	0.000	0	0	1	1.0288	7.54	220	2	1.05	0.95	;
	62	1	0.000	0.000	0	0	1	1.0297	7.48	220	2	1.05	0.95	;
	63	1	0.000	0.000	0	0	1	1.0434	18.77	220	2	1.05	0.95	;
	64	2	0.000	0.000	0	0	1	1.0189	-2.2	220	2	1.05	0.95	;
	65	2	0.000	0.000	0	0	1	1.0341	8.13	220	2	1.05	0.95	;
	66	1	0.000	0.000	0	0	1	1.0307	8.03	220	2	1.05	0.95	;
	67	1	1.984	-0.198	0	0	1	1.0248	6.45	220	2	1.05	0.95	;
	68	1	0.000	0.000	0	0	1	1.0218	5.66	220	2	1.05	0.95	;
	69	1	0.000	0.000	0	0	1	1.0266	4.45	220	2	1.05	0.95	;
	71	1	0.000	0.000	0	0	1	1.0245	1.89	220	2	1.05	0.95	;
	72	1	0.000	0.000	0	-70	1	1.0228	7.19	220	2	1.05	0.95	;
	73	2	0.000	0.000	0	0	1	1.0306	14.75	220	2	1.05	0.95	;
	74	1	0.000	0.000	0	0	1	1.0216	-2.64	220	2	1.05	0.95	;
	75	1	0.000	0.000	0	0	1	1.0305	9.58	220	2	1.05	0.95	;
	76	1	0.000	0.000	0	0	1	1.0209	-3.92	220	2	1.05	0.95	;
	77	1	0.000	0.000	0	0	1	1.0357	17.15	220	2	1.05	0.95	;
	78	1	0.000	0.000	0	-70	1	1.0248	3.8	220	2	1.05	0.95	;
	79	1	0.000	0.000	0	0	1	1.0295	11.37	220	2	1.05	0.95	;
	80	1	0.000	0.000	0	0	1	1.0408	-2.08	400	2	1.05	0.95	;
	81	1	0.000	0.000	0	0	1	1.0383	8.14	400	2	1.05	0.95	;
	82	1	0.000	0.000	0	0	1	1.0415	-1.03	400	2	1.05	0.95	;
	83	1	0.000	0.000	0	0	1	1.0433	3.76	400	2	1.05	0.95	;
	84	1	0.000	0.000	0	0	1	1.0399	-2.61	400	2	1.05	0.95	;
	85	1	0.000	0.000	0	-150	1	1.0399	1.97	400	2	1.05	0.95	;
	86	1	0.000	0.000	0	0	1	1.0406	-2.86	400	2	1.05	0.95	;
	87	1	0.000	0.000	0	0	1	1.04	-3.06	400	2	1.05	0.95	;
	88	1	0.000	0.000	0	0	1	1.0412	9.51	400	2	1.05	0.95	;
	89	1	0.000	0.000	0	-150	1	1.0423	-1.12	400	2	1.05	0.95	;
	90	1	0.000	0.000	0	-150	1	1.0455	10	400	2	1.05	0.95	;
	91	1	0.000	0.000	0	0	1	1.0434	10.37	400	2	1.05	0.95	;
	92	1	0.000	0.000	0	-150	1	1.0397	9.26	400	2	1.05	0.95	;
	93	1	0.000	0.000	0	0	1	1.0401	8.69	400	2	1.05	0.95	;
	94	1	0.000	0.000	0	0	1	1.0398	8.52	400	2	1.05	0.95	;
	95	1	0.000	0.000	0	0	1	1.0462	6.47	400	2	1.05	0.95	;
	96	1	0.000	0.000	0	0	1	1.0464	11.54	400	2	1.05	0.95	;
	97	2	0.000	0.000	0	0	1	1.041	-2.55	400	2	1.05	0.95	;
	98	1	0.000	0.000	0	0	1	1.045	5.42	400	2	1.05	0.95	;
	99	1	0.000	0.000	0	0	1	1.0451	5.02	400	2	1.05	0.95	;
	100	1	0.000	0.000	0	0	1	1.0418	-0.01	400	2	1.05	0.95	;
	101	1	0.000	0.000	0	-150	1	1.0411	7.03	400	2	1.05	0.95	;
	102	1	0.000	0.000	0	-150	1	1.0235	-4.4	400	2	1.05	0.95	;
	103	1	0.000	0.000	0	0	1	1.045	8.46	400	2	1.05	0.95	;
	104	1	0.000	0.000	0	-150	1	1.0414	10.18	400	2	1.05	0.95	;
	105	1	0.000	0.000	0	0	1	1.0413	0.77	400	2	1.05	0.95	;
	106	1	0.000	0.000	0	0	1	1.0488	14.19	400	2	1.05	0.95	;
	107	2	0.000	0.000	0	0	1	1.0282	-4.4	400	2	1.05	0.95	;
	108	2	45.736	12.897	0	0	1	1.0075	7.43	130	2	1.05	0.95	;
	109	2	235.129	34.228	0	0	1	1.0153	-3.59	63	2	1.05	0.95	;
	110	2	183.937	10.417	0	0	1	1.0228	-6.44	63	2	1.05	0.95	;
	111	2	176.297	21.132	0	0	1	1.0215	2.58	63	2	1.05	0.95	;
	112	2	223.125	31.053	0	0	1	1.0201	-6.69	63	2	1.05	0.95	;
	113	2	121.533	17.461	0	0	1	1.0261	-6.9	63	2	1.05	0.95	;
	114	2	211.220	28.771	0	0	1	1.0288	-0.63	63	2	1.05	0.95	;
	115	2	33.632	6.250	0	0	1	1.0196	13.98	63	2	1.05	0.95	;
	116	2	267.174	53.078	0	0	1	1.0192	4.12	63	2	1.05	0.95	;
	117	2	67.662	8.234	0	0	1	1.0144	-8.21	63	2	1.05	0.95	;
	118	2	97.822	24.803	0	0	1	1.0221	4.88	63	2	1.05	0.95	;
	119	2	281.064	48.712	0	0	1	1.0343	-5.13	63	2	1.05	0.95	;
	120	2	243.860	45.439	0	0	1	1.0246	2.66	63	2	1.05	0.95	;
	121	2	143.856	27.283	0	0	1	1.0169	-9.88	63	2	1.05	0.95	;
	122	2	238.999	48.316	0	0	1	1.0342	0.14	63	2	1.05	0.95	;
	123	2	206.457	8.731	0	0	1	1.0272	-7.98	63	2	1.05	0.95	;
	124	2	147.328	38.593	0	0	1	1.0244	-2.21	63	2	1.05	0.95	;
	125	2	135.026	11.905	0	0	1	1.0207	-4.9	63	2	1.05	0.95	;
	126	2	110.422	14.584	0	0	1	1.0276	-5.18	63	2	1.05	0.95	;
	127	2	134.728	25.200	0	0	1	1.0246	5.51	63	2	1.05	0.95	;
	128	2	286.620	64.289	0	0	1	1.0295	7.01	63	2	1.05	0.95	;
	129	2	203.680	28.672	0	0	1	1.0248	3.01	63	2	1.05	0.95	;
	130	2	304.478	60.618	0	0	1	1.0162	2.94	63	2	1.05	0.95	;
	131	2	169.154	27.481	0	0	1	1.0277	-3.14	63	2	1.05	0.95	;
	132	2	60.419	11.806	0	0	1	1.0113	2.19	63	2	1.05	0.95	;
	133	2	209.731	50.002	0	0	1	1.0261	6.69	63	2	1.05	0.95	;
	134	2	197.727	33.136	0	0	1	1.0241	3.85	63	2	1.05	0.95	;
	135	2	198.521	20.537	0	0	1	1.0242	-6.31	63	2	1.05	0.95	;
	136	2	258.146	30.557	0	0	1	1.0275	-8.28	63	2	1.05	0.95	;
	137	2	145.641	36.807	0	0	1	1.0263	6.12	63	2	1.05	0.95	;
	138	2	155.662	28.374	0	0	1	1.0219	4.83	63	2	1.05	0.95	;
	139	2	190.981	21.529	0	0	1	1.0208	-6.97	63	2	1.05	0.95	;
	140	2	51.391	8.830	0	0	1	1.0145	-8.94	63	2	1.05	0.95	;
	141	2	108.040	9.127	0	0	1	1.0186	-8.58	63	2	1.05	0.95	;
	142	2	158.043	27.085	0	0	1	1.0258	5.38	63	2	1.05	0.95	;
	143	1	94.746	10.020	0	0	1	1.0158	-6.49	63	2	1.05	0.95	;
	144	2	77.384	8.234	0	0	1	1.0245	5.53	63	2	1.05	0.95	;
	145	2	201.398	39.783	0	0	1	1.0246	6.12	63	2	1.05	0.95	;
	146	2	18.850	2.877	0	0	1	1.0175	-6.53	63	2	1.05	0.95	;
	147	2	72.523	10.020	0	0	1	1.0263	-4.37	63	2	1.05	0.95	;
	148	1	0.000	0.000	0	0	1	1.0078	10.4	63	2	1.05	0.95	;
	149	2	187.012	32.243	0	0	1	1.0203	-11.56	63	2	1.05	0.95	;
	150	2	47.026	10.020	0	0	1	1.0125	6.75	63	2	1.05	0.95	;
	151	2	229.871	58.038	0	0	1	1.0209	5.23	63	2	1.05	0.95	;
	152	2	79.269	19.148	0	0	1	1.0189	6.61	63	2	1.05	0.95	;
	153	2	12.004	3.076	0	0	1	1.0275	18.2	63	2	1.05	0.95	;
	154	2	96.334	9.723	0	0	1	1.0168	-4.6	63	2	1.05	0.95	;
	155	2	59.328	14.981	0	0	1	1.0313	7.3	63	2	1.05	0.95	;
	156	2	32.541	6.548	0	0	1	1.0255	7.43	63	2	1.05	0.95	;
	157	2	133.934	21.529	0	0	1	1.0168	2.02	63	2	1.05	0.95	;
	158	2	96.929	18.156	0	0	1	1.0277	4.72	63	2	1.05	0.95	;
	159	2	105.064	17.461	0	0	1	1.0294	-9.44	63	2	1.05	0.95	;
	160	2	109.330	12.897	0	0	1	1.0319	6.69	63	2	1.05	0.95	;
	161	2	17.759	5.060	0	0	1	1.021	1.58	63	2	1.05	0.95	;
	162	2	68.654	12.203	0	0	1	1.0135	5.68	63	2	1.05	0.95	;
	163	2	13.493	9.127	0	0	1	1.0234	11.76	63	2	1.05	0.95	;
	164	2	42.065	5.060	0	0	1	1.0258	-0.15	63	2	1.05	0.95	;
	165	2	51.986	12.798	0	0	1	1.0073	13.48	63	2	1.05	0.95	;
	166	2	133.934	18.552	0	0	1	1.024	-5.86	63	2	1.05	0.95	;
	167	2	38.791	7.143	0	0	1	1.008	9.29	63	2	1.05	0.95	;
	168	2	149.014	26.489	0	0	1	1.0264	-4.81	63	2	1.05	0.95	;
	169	2	19.445	11.608	0	0	1	1.0269	-6.78	63	2	1.05	0.95	;
	170	2	38.990	11.112	0	0	1	1.0198	2.86	63	2	1.05	0.95	;
	171	2	67.166	7.540	0	0	1	1.0254	2.37	63	2	1.05	0.95	;
	172	2	40.974	7.540	0	0	1	1.0074	10.63	63	2	1.05	0.95	;
	173	2	0.000	0.000	0	0	1	1.0378	12.11	150	2	1.05	0.95	;
	174	2	0.000	0.000	0	0	1	1.0367	11.65	150	2	1.05	0.95	;
	175	2	0.000	0.000	0	0	1	1.0083	-0.73	150	2	1.05	0.95	;
	176	2	0.000	0.000	0	0	1	1.0082	-0.73	150	2	1.05	0.95	;
	177	2	0.000	0.000	0	0	1	1.0391	12.28	150	2	1.05	0.95	;
	178	2	0.000	0.000	0	0	1	1.026	11.18	150	2	1.05	0.95	;
	179	2	0.000	0.000	0	0	1	1.0364	11.05	150	2	1.05	0.95	;
	180	1	0.000	0.000	0	0	1	1.0284	-5.39	150	2	1.05	0.95	;
	181	2	0.000	0.000	0	0	1	1.0262	7.79	150	2	1.05	0.95	;
	182	2	0.000	0.000	0	0	1	1.0373	12	150	2	1.05	0.95	;
	184	1	0.000	0.000	0	0	1	1.0336	10.53	150	2	1.05	0.95	;
	185	1	0.000	0.000	0	0	1	1.0315	-4.96	150	2	1.05	0.95	;
	186	1	0.000	0.000	0	0	1	1.0261	-5.98	150	2	1.05	0.95	;
	187	2	0.000	0.000	0	0	1	1.0183	-0.91	220	2	1.05	0.95	;
	188	2	0.000	0.000	0	0	1	1.0183	-0.91	220	2	1.05	0.95	;
	189	2	0.000	0.000	0	0	1	1.0183	-0.91	220	2	1.05	0.95	;
	190	1	0.000	0.000	0	0	1	1.0201	5.61	220	2	1.05	0.95	;
	191	2	0.000	0.000	0	0	1	1.0484	21.77	220	2	1.05	0.95	;
	192	2	0.000	0.000	0	0	1	1.0429	19.27	220	2	1.05	0.95	;
	193	1	0.000	0.000	0	0	1	1.0211	5.78	220	2	1.05	0.95	;
	194	2	0.000	0.000	0	0	1	1.0412	13.38	220	2	1.05	0.95	;
	195	2	0.000	0.000	0	0	1	1.0296	3.68	220	2	1.05	0.95	;
	196	2	0.000	0.000	0	0	1	1.0462	14.08	220	2	1.05	0.95	;
	198	2	0.000	0.000	0	0	1	1.0477	15.23	220	2	1.05	0.95	;
	199	1	0.000	0.000	0	0	1	1.0247	1.1	220	2	1.05	0.95	;
	200	2	0.000	0.000	0	0	1	1.0462	20.68	220	2	1.05	0.95	;
	201	2	0.000	0.000	0	0	1	1.0462	20.68	220	2	1.05	0.95	;
	202	2	0.000	0.000	0	0	1	1.0462	20.68	220	2	1.05	0.95	;
	203	2	0.000	0.000	0	0	1	1.0462	20.71	220	2	1.05	0.95	;
	204	1	0.000	0.000	0	0	1	1.0216	-3.76	220	2	1.05	0.95	;
	205	1	0.000	0.000	0	0	1	1.0217	-3.91	220	2	1.05	0.95	;
	206	2	0.000	0.000	0	0	1	1.0295	7.51	220	2	1.05	0.95	;
	207	2	0.000	0.000	0	0	1	1.0295	7.51	220	2	1.05	0.95	;
	208	1	0.000	0.000	0	0	1	1.0229	5.83	220	2	1.05	0.95	;
	209	1	0.000	0.000	0	0	1	1.0233	5.85	220	2	1.05	0.95	;
	210	1	0.000	0.000	0	0	1	1.023	5.89	220	2	1.05	0.95	;
	211	1	0.000	0.000	0	0	1	1.0236	5.95	220	2	1.05	0.95	;
	212	1	0.000	0.000	0	0	1	1.029	7.53	220	2	1.05	0.95	;
	213	1	0.000	0.000	0	0	1	1.0231	-3.48	220	2	1.05	0.95	;
	214	1	0.000	0.000	0	0	1	1.0232	-3.47	220	2	1.05	0.95	;
	215	1	0.000	0.000	0	0	1	1.0231	-3.49	220	2	1.05	0.95	;
	216	1	0.000	0.000	0	0	1	1.0232	-3.47	220	2	1.05	0.95	;
	217	1	0.000	0.000	0	0	1	1.0243	-3.51	220	2	1.05	0.95	;
	218	2	0.000	0.000	0	0	1	1.0308	8.05	220	2	1.05	0.95	;
	219	1	0.000	0.000	0	0	1	1.0213	-3.93	220	2	1.05	0.95	;
	220	1	0.000	0.000	0	0	1	1.0219	5.94	220	2	1.05	0.95	;
	221	1	0.000	0.000	0	0	1	1.0219	5.94	220	2	1.05	0.95	;
	222	2	0.000	0.000	0	0	1	1.0225	-2.24	220	2	1.05	0.95	;
	223	1	0.000	0.000	0	0	1	1.0273	3.84	220	2	1.05	0.95	;
	224	1	0.000	0.000	0	0	1	1.0285	7.46	220	2	1.05	0.95	;
	225	2	0.000	0.000	0	0	1	1.0485	14.72	400	2	1.05	0.95	;
	226	1	0.000	0.000	0	0	1	1.0429	-2.57	400	2	1.05	0.95	;
	227	2	0.000	0.000	0	0	1	1.0413	0.79	400	2	1.05	0.95	;
	228	2	0.000	0.000	0	0	1	1.0413	0.79	400	2	1.05	0.95	;
	229	2	0.000	0.000	0	0	1	1.0434	10.37	400	2	1.05	0.95	;
	230	2	0.000	0.000	0	0	1	1.0439	10.46	400	2	1.05	0.95	;
	231	2	0.000	0.000	0	0	1	1.0471	10.76	400	2	1.05	0.95	;
	232	2	0.000	0.000	0	0	1	1.0464	11.54	400	2	1.05	0.95	;
	233	2	0.000	0.000	0	0	1	1.0464	11.54	400	2	1.05	0.95	;
	239	3	0.000	0.000	0	0	1	1.0418	0	400	2	1.05	0.95	;
	240	2	0.000	0.000	0	0	1	1.0418	-0.01	400	2	1.05	0.95	;
	241	2	0.000	0.000	0	0	1	1.0472	6.91	400	2	1.05	0.95	;
	242	2	0.000	0.000	0	0	1	1.047	6.84	400	2	1.05	0.95	;
	243	2	0.000	0.000	0	0	1	1.0451	5.02	400	2	1.05	0.95	;
	244	2	0.000	0.000	0	0	1	1.0451	5.02	400	2	1.05	0.95	;
	245	1	33.732	9.127	0	0	1	1.0202	-6.72	150	2	1.05	0.95	;
	246	1	14.882	3.076	0	0	1	1.0279	-5.44	150	2	1.05	0.95	;
	247	1	4.464	-0.397	0	0	1	1.026	-6.02	150	2	1.05	0.95	;
	248	1	0.992	-0.595	0	0	1	1.0196	6.81	150	2	1.05	0.95	;
	249	1	5.457	-0.198	0	0	1	1.0284	-5.42	150	2	1.05	0.95	;
	250	2	15.874	5.258	0	0	1	1.0346	-4.21	150	2	1.05	0.95	;
	251	2	0.000	0.000	0	0	1	1.0279	9.05	150	2	1.05	0.95	;
	252	2	0.000	0.000	0	0	1	1.0205	7.01	150	2	1.05	0.95	;
	253	2	0.000	0.000	0	0	1	1.0196	6.93	150	2	1.05	0.95	;
	254	2	0.000	0.000	0	0	1	1.0308	10.03	150	2	1.05	0.95	;
	255	2	24.803	9.028	0	0	1	1.0357	-3.7	150	2	1.05	0.95	;
	256	1	94.250	27.085	0	0	1	1.0193	5.53	220	2	1.05	0.95	;
	257	1	2.976	-2.381	0	0	1	1.0311	6.85	220	2	1.05	0.95	;
	258	1	2.976	-2.282	0	0	1	1.0267	3.17	220	2	1.05	0.95	;
	259	1	2.480	-2.480	0	0	1	1.0328	7.79	220	2	1.05	0.95	;
	260	1	124.013	32.144	0	0	1	0.9953	-5.54	220	2	1.05	0.95	;
	261	1	0.992	-1.488	0	0	1	1.0271	7.34	220	2	1.05	0.95	;
	262	2	0.000	0.000	0	0	1	1.0281	3.88	220	2	1.05	0.95	;
	263	2	0.000	0.000	0	0	1	1.0285	7.56	220	2	1.05	0.95	;
	264	2	0.000	0.000	0	0	1	1.0286	7.47	220	2	1.05	0.95	;
	265	2	0.000	0.000	0	0	1	1.0273	3.84	220	2	1.05	0.95	;
	266	2	0.000	0.000	0	0	1	1.029	7.53	220	2	1.05	0.95	;
	267	2	0.000	0.000	0	0	1	1.0305	9.58	220	2	1.05	0.95	;
	268	2	0.000	0.000	0	0	1	1.0459	10.01	400	2	1.05	0.95	;
	269	1	0.000	0.000	0	0	1	1.0172	13.86	63	2	1.05	0.95	;
	270	1	0.000	0.000	0	0	1	1.0172	13.86	63	2	1.05	0.95	;
	271	1	0.000	0.000	0	0	1	1.0151	13.77	63	2	1.05	0.95	;
	272	1	0.000	0.000	0	0	1	1.0103	13.58	63	2	1.05	0.95	;
	273	2	0.000	0.000	0	0	1	1.0309	5.43	63	2	1.05	0.95	;
	274	1	0.000	0.000	0	0	1	1.0304	5.37	63	2	1.05	0.95	;
	275	1	0.000	0.000	0	0	1	1.0297	5.3	63	2	1.05	0.95	;
	276	1	0.000	0.000	0	0	1	1.0233	4.59	63	2	1.05	0.95	;
	277	1	0.000	0.000	0	0	1	1.023	4.54	63	2	1.05	0.95	;
	278	1	0.000	0.000	0	0	1	1.0218	4.42	63	2	1.05	0.95	;
	279	1	0.000	0.000	0	0	1	1.0196	4.17	63	2	1.05	0.95	;
	280	1	0.000	0.000	0	0	1	1.0197	3.5	63	2	1.05	0.95	;
	281	1	0.000	0.000	0	0	1	1.025	4.34	63	2	1.05	0.95	;
	282	1	0.000	0.000	0	0	1	1.0289	5.06	63	2	1.05	0.95	;
	283	1	0.000	0.000	0	0	1	1.0113	2.2	63	2	1.05	0.95	;
	284	1	0.000	0.000	0	0	1	1.0205	5.05	63	2	1.05	0.95	;
	285	1	0.000	0.000	0	0	1	1.0207	5.1	63	2	1.05	0.95	;
	286	1	0.000	0.000	0	0	1	1.0244	6.07	63	2	1.05	0.95	;
	287	1	0.000	0.000	0	0	1	1.027	9.43	150	2	1.05	0.95	;
	288	1	0.000	0.000	0	0	1	1.0269	9.43	150	2	1.05	0.95	;
	289	1	0.000	0.000	0	0	1	1.0283	9.75	150	2	1.05	0.95	;
	290	1	0.000	0.000	0	0	1	1.0295	10.03	150	2	1.05	0.95	;
	291	1	0.000	0.000	0	0	1	1.0299	10.12	150	2	1.05	0.95	;
	292	1	0.000	0.000	0	0	1	1.03	10.14	150	2	1.05	0.95	;
	293	2	0.000	0.000	0	0	1	1.0333	10.71	150	2	1.05	0.95	;
	294	1	0.000	0.000	0	0	1	1.008	10	63	2	1.05	0.95	;
	295	1	0.000	0.000	0	0	1	1.0081	9.49	63	2	1.05	0.95	;
	296	1	0.000	0.000	0	0	1	1.0081	9.39	63	2	1.05	0.95	;
	297	1	0.000	0.000	0	0	1	1.0081	9.35	63	2	1.05	0.95	;
	298	1	0.000	0.000	0	0	1	1.0087	12.83	63	2	1.05	0.95	;
	299	1	0.000	0.000	0	0	1	1.0087	12.83	63	2	1.05	0.95	;
	300	1	0.000	0.000	0	0	1	1.0087	12.83	63	2	1.05	0.95	;
	301	1	0.000	0.000	0	0	1	1.0087	12.22	63	2	1.05	0.95	;
	302	1	0.000	0.000	0	0	1	1.0085	11.66	63	2	1.05	0.95	;
	303	1	0.000	0.000	0	0	1	1.0079	11.02	63	2	1.05	0.95	;
	304	1	0.000	0.000	0	0	1	1.0079	11.02	63	2	1.05	0.95	;
	306	1	0.000	0.000	0	0	1	1.0254	9.08	150	2	1.05	0.95	;
	307	1	0.000	0.000	0	0	1	1.0243	9	150	2	1.05	0.95	;
	308	1	19.842	3.968	0	0	1	1.0228	5.82	220	2	1.05	0.95	;
	309	2	0.000	0.000	0	0	1	1.03	7.5	220	2	1.05	0.95	;
	310	1	0.000	0.000	0	0	1	1.0488	11.49	400	2	1.05	0.95	;
	311	2	0.000	0.000	0	0	1	1.0465	10.37	400	2	1.05	0.95	;
	312	1	0.000	0.000	0	0	1	1.0421	9.62	400	2	1.05	0.95	;
	313	2	0.000	0.000	0	0	1	1.0481	1.63	400	2	1.05	0.95	;
	314	2	0.000	0.000	0	0	1	1.0366	-3.09	400	2	1.05	0.95	;
	315	2	0.000	0.000	0	0	1	1.0472	-0.55	400	2	1.05	0.95	;
	316	2	16.866	-2.183	0	0	1	1.0483	2.72	400	2	1.05	0.95	;
	317	2	0.000	0.000	0	0	1	1.0486	12.41	400	2	1.05	0.95	;
	318	1	0.000	0.000	0	0	1	1.0482	7.95	400	2	1.05	0.95	;
	319	2	154.769	32.839	0	0	1	1.0275	7.68	63	2	1.05	0.95	;
	320	2	44.248	7.441	0	0	1	1.03	1.39	63	2	1.05	0.95	;
	321	2	25.200	3.572	0	0	1	1.0249	-0.82	63	2	1.05	0.95	;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf
mpc.gen = [
	1	363.637	-43.001	9999.000	-9999.000	1.0473	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	2	43.282	-82.020	9999.000	-9999.000	1.0479	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	3	13.229	-88.346	9999.000	-9999.000	1.0407	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	4	20.321	-60.469	9999.000	-9999.000	1.0363	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	5	114.274	-14.655	9999.000	-9999.000	1.0476	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	6	73.566	-9.689	9999.000	-9999.000	1.0471	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	7	0.000	9.844	9999.000	-9999.000	1.0314	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	305	110.878	-18.825	9999.000	-9999.000	1.0442	100.00	1	9999.000	-9999.000	0	0	0	0	0	0	0	0	0	0	0	;
	10	0.000	0.000	40.734	-40.734	1.0341	109.68	0	101.835	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	14	0.000	0.000	46.928	-46.928	1.0296	126.36	0	117.321	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	22	0.000	0.000	29.539	-29.539	1.0276	79.54	0	73.848	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	22	0.000	0.000	39.791	-39.791	1.0276	107.14	0	99.478	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	24	0.000	0.000	46.928	-46.928	1.0214	126.36	0	117.321	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	29	0.000	0.000	30.551	-30.551	1.0240	82.26	0	76.376	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	30	31.000	1.612	15.500	-12.400	1.0339	34.66	1	31.000	15.500	0	0	0	0	0	0	0	0	0	0	0	;
	30	0.000	0.000	15.500	-12.400	1.0339	34.66	0	31.000	15.500	0	0	0	0	0	0	0	0	0	0	0	;
	34	0.000	0.000	50.918	-50.918	1.0289	137.10	0	127.294	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	61	50.000	2.989	30.000	-24.000	1.0288	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	61	56.000	2.989	30.000	-24.000	1.0288	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	61	0.000	0.000	30.000	-24.000	1.0288	67.08	0	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	64	0.000	0.000	32.498	-32.498	1.0189	87.50	0	81.245	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	65	1.406	2.786	17.990	-17.990	1.0341	48.44	1	44.975	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	73	2.407	4.150	30.789	-30.789	1.0306	82.90	1	76.974	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	97	0.000	0.000	46.928	-46.928	1.0410	126.36	0	117.321	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	107	0.000	0.000	81.468	-81.468	1.0282	219.36	0	203.670	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	108	0.585	1.200	7.487	-7.487	1.0075	20.16	1	18.718	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	108	8.189	1.488	9.285	-9.285	1.0075	25.00	1	23.212	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	15.000	2.832	7.750	-6.200	1.0153	17.33	1	15.500	7.750	0	0	0	0	0	0	0	0	0	0	0	;
	109	27.000	5.480	15.000	-12.000	1.0153	33.54	1	30.000	15.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	34.628	7.754	24.038	-24.038	1.0153	64.72	1	60.095	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	1.354	5.590	17.329	-17.329	1.0153	46.66	1	43.323	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	5.143	0.000	0.000	0.000	1.0153	15.70	1	15.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	109	0.000	0.000	4.797	-4.797	1.0153	12.92	0	11.992	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	110	10.018	-1.362	6.954	-6.954	1.0228	18.72	1	17.385	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	110	0.000	0.000	3.441	-3.441	1.0228	9.26	0	8.602	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	111	3.758	0.303	2.609	-2.609	1.0215	7.02	1	6.522	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	112	112.202	0.611	77.890	-77.890	1.0201	209.72	1	194.724	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	112	0.000	0.000	13.116	-13.116	1.0201	35.32	0	32.789	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	113	1.030	0.044	0.715	-0.715	1.0261	1.92	1	1.787	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	113	2.195	0.000	0.000	0.000	1.0261	6.70	1	6.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	113	0.000	0.000	29.219	-29.219	1.0261	78.67	0	73.047	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	15.635	4.060	10.854	-10.854	1.0288	29.22	1	27.134	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	3.857	18.456	49.343	-49.343	1.0288	132.86	1	123.357	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	4.422	0.000	0.000	0.000	1.0288	13.50	1	13.500	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	8.844	3.751	10.028	-10.028	1.0288	27.00	1	25.069	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	114	0.000	0.000	4.945	-4.945	1.0288	13.32	0	12.363	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	15.000	0.570	9.000	-7.200	1.0196	20.12	1	18.000	-18.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	15.000	0.570	9.000	-7.200	1.0196	20.12	1	18.000	-18.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	1.244	-0.011	0.863	-0.863	1.0196	2.32	1	2.158	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	0.405	-0.068	5.185	-5.185	1.0196	13.96	1	12.962	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	115	3.341	0.000	0.000	0.000	1.0196	10.20	1	10.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	116	37.410	13.399	25.969	-25.969	1.0192	69.92	1	64.923	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	116	0.590	0.000	0.000	0.000	1.0192	1.80	1	1.800	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	116	0.000	0.000	4.165	-4.165	1.0192	11.22	0	10.413	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	117	0.709	-0.043	0.492	-0.492	1.0144	1.32	1	1.230	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	117	0.000	0.000	9.402	-9.402	1.0144	25.32	0	23.505	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	118	21.413	6.541	14.865	-14.865	1.0221	40.02	1	37.162	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	118	0.202	1.138	2.585	-2.585	1.0221	6.96	1	6.462	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	118	8.025	0.000	0.000	0.000	1.0221	24.50	1	24.500	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	118	26.040	12.992	29.526	-29.526	1.0221	79.50	1	73.814	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	119	3.491	-0.014	2.423	-2.423	1.0343	6.52	1	6.058	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	119	1.221	-0.088	15.621	-15.621	1.0343	42.06	1	39.052	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	119	0.000	0.000	4.165	-4.165	1.0343	11.22	0	10.413	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	120	15.421	5.398	10.705	-10.705	1.0246	28.82	1	26.763	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	120	1.439	9.281	18.406	-18.406	1.0246	49.56	1	46.015	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	120	6.551	0.000	0.000	0.000	1.0246	20.00	1	20.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	120	0.000	0.000	5.057	-5.057	1.0246	13.62	0	12.642	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	121	0.353	1.632	4.516	-4.516	1.0169	12.16	1	11.290	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	121	0.328	0.000	0.000	0.000	1.0169	1.00	1	1.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	121	0.000	0.000	12.815	-12.815	1.0169	34.51	0	32.038	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	122	12.104	3.744	8.402	-8.402	1.0342	22.62	1	21.006	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	122	4.330	24.685	55.397	-55.397	1.0342	149.16	1	138.492	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	122	0.000	0.000	3.460	-3.460	1.0342	9.32	0	8.649	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	123	24.463	-1.068	16.982	-16.982	1.0272	45.72	1	42.454	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	123	0.000	0.000	10.479	-10.479	1.0272	28.22	0	26.197	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	124	0.762	0.280	0.529	-0.529	1.0244	1.42	1	1.322	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	124	6.504	44.076	83.214	-83.214	1.0244	224.06	1	208.034	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	124	0.426	0.000	0.000	0.000	1.0244	1.30	1	1.300	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	125	0.661	0.245	8.453	-8.453	1.0207	22.76	1	21.132	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	126	19.915	-1.716	13.825	-13.825	1.0276	37.22	1	34.562	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	126	0.754	-1.197	9.641	-9.641	1.0276	25.96	1	24.103	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	126	0.000	0.000	11.918	-11.918	1.0276	32.09	0	29.795	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	1.190	0.176	0.826	-0.826	1.0246	2.22	1	2.065	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	9.999	27.225	127.929	-127.929	1.0246	344.46	1	319.823	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	15.035	0.000	0.000	0.000	1.0246	45.90	1	45.900	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	10.072	2.430	11.420	-11.420	1.0246	30.75	1	28.551	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	127	0.000	0.000	3.441	-3.441	1.0246	9.26	0	8.602	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	128	87.164	35.620	60.509	-60.509	1.0295	162.92	1	151.271	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	128	0.228	1.718	2.919	-2.919	1.0295	7.86	1	7.298	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	128	14.904	0.000	0.000	0.000	1.0295	45.50	1	45.500	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	128	0.000	0.000	4.388	-4.388	1.0295	11.82	0	10.970	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	129	63.000	16.991	37.500	-30.000	1.0248	83.85	1	75.000	37.500	0	0	0	0	0	0	0	0	0	0	0	;
	129	38.854	11.331	26.972	-26.972	1.0248	72.62	1	67.430	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	129	1.163	6.250	14.878	-14.878	1.0248	40.06	1	37.195	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	129	5.994	0.000	0.000	0.000	1.0248	18.30	1	18.300	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	130	5.310	0.722	3.686	-3.686	1.0162	9.92	1	9.215	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	131	45.862	-6.742	31.837	-31.837	1.0277	85.72	1	79.593	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	131	1.871	-5.070	23.940	-23.940	1.0277	64.46	1	59.850	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	131	0.000	0.000	10.219	-10.219	1.0277	27.52	0	25.547	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	132	18.471	3.220	12.822	-12.822	1.0113	34.52	1	32.055	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	132	0.788	2.533	10.087	-10.087	1.0113	27.16	1	25.217	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	132	0.000	0.000	3.441	-3.441	1.0113	9.26	0	8.602	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	133	74.057	24.219	51.409	-51.409	1.0261	138.42	1	128.524	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	133	3.813	22.982	48.786	-48.786	1.0261	131.36	1	121.965	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	133	5.470	0.000	0.000	0.000	1.0261	16.70	1	16.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	134	100.004	43.039	69.422	-69.422	1.0241	186.92	1	173.555	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	134	0.000	0.000	3.868	-3.868	1.0241	10.42	0	9.670	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	135	0.117	-0.087	1.495	-1.495	1.0242	4.03	1	3.739	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	136	3.598	-0.085	2.497	-2.497	1.0275	6.72	1	6.243	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	136	0.000	0.000	4.908	-4.908	1.0275	13.22	0	12.270	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	137	15.796	4.757	10.965	-10.965	1.0263	29.52	1	27.413	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	137	1.418	7.872	18.146	-18.146	1.0263	48.86	1	45.365	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	137	1.605	0.000	0.000	0.000	1.0263	4.90	1	4.900	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	138	3.598	0.367	2.497	-2.497	1.0219	6.72	1	6.243	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	138	2.162	0.000	0.000	0.000	1.0219	6.60	1	6.600	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	138	0.000	0.000	5.577	-5.577	1.0219	15.02	0	13.941	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	139	5.363	-0.199	3.723	-3.723	1.0208	10.02	1	9.307	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	139	0.000	0.000	3.441	-3.441	1.0208	9.26	0	8.602	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	140	2.260	0.000	0.000	0.000	1.0145	6.90	1	6.900	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	140	0.000	0.000	40.487	-40.487	1.0145	109.02	0	101.218	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	141	7.236	0.274	5.023	-5.023	1.0186	13.52	1	12.557	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	141	0.000	0.000	3.441	-3.441	1.0186	9.26	0	8.602	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	142	10.713	3.595	7.437	-7.437	1.0258	20.02	1	18.592	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	142	3.418	21.139	43.735	-43.735	1.0258	117.76	1	109.337	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	142	9.040	0.000	0.000	0.000	1.0258	27.60	1	27.600	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	142	0.000	0.000	3.460	-3.460	1.0258	9.32	0	8.649	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	144	1.244	0.189	0.863	-0.863	1.0245	2.32	1	2.158	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	144	3.360	9.414	42.992	-42.992	1.0245	115.76	1	107.480	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	145	216.420	29.523	150.237	-150.237	1.0246	404.52	1	375.591	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	145	0.405	1.019	5.185	-5.185	1.0246	13.96	1	12.962	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	146	0.000	0.000	9.099	-9.099	1.0175	24.50	0	22.747	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	147	3.330	-0.172	2.312	-2.312	1.0263	6.22	1	5.779	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	147	0.000	0.000	4.908	-4.908	1.0263	13.22	0	12.270	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	149	1.297	0.211	0.900	-0.900	1.0203	2.42	1	2.251	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	149	0.000	0.000	8.330	-8.330	1.0203	22.43	0	20.825	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	4.000	-3.200	1.0125	8.94	0	8.000	4.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	6.000	0.346	4.400	-3.520	1.0125	9.84	1	8.800	4.400	0	0	0	0	0	0	0	0	0	0	0	;
	150	6.000	0.346	4.400	-3.520	1.0125	9.84	1	8.800	4.400	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	4.400	-3.520	1.0125	9.84	0	8.800	4.400	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	4.400	-3.520	1.0125	9.84	0	8.800	4.400	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	4.000	-3.200	1.0125	8.94	0	8.000	4.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	12.500	-10.000	1.0125	27.95	0	25.000	12.500	0	0	0	0	0	0	0	0	0	0	0	;
	150	28.850	0.083	20.027	-20.027	1.0125	53.92	1	50.067	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	1.944	0.103	24.868	-24.868	1.0125	66.96	1	62.171	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	1.834	0.000	0.000	0.000	1.0125	5.60	1	5.600	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	150	0.000	0.000	12.336	-12.336	1.0125	33.22	0	30.840	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	151	15.154	5.601	10.519	-10.519	1.0209	28.32	1	26.298	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	151	3.669	0.000	0.000	0.000	1.0209	11.20	1	11.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	151	0.000	0.000	3.441	-3.441	1.0209	9.26	0	8.602	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	14.351	-0.268	9.962	-9.962	1.0189	26.82	1	24.906	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	2.980	-1.025	38.127	-38.127	1.0189	102.66	1	95.317	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	8.778	0.000	0.000	0.000	1.0189	26.80	1	26.800	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	10.809	-0.329	12.256	-12.256	1.0189	33.00	1	30.640	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	152	0.000	0.000	3.460	-3.460	1.0189	9.32	0	8.649	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	153	0.289	0.135	3.699	-3.699	1.0275	9.96	1	9.248	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	153	0.000	0.000	3.460	-3.460	1.0275	9.32	0	8.649	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	154	2.902	0.063	2.015	-2.015	1.0168	5.42	1	5.036	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	154	0.000	0.000	4.054	-4.054	1.0168	10.92	0	10.135	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	155	0.000	0.000	20.000	-16.000	1.0313	44.72	0	40.000	20.000	0	0	0	0	0	0	0	0	0	0	0	;
	155	0.869	0.204	0.603	-0.603	1.0313	1.62	1	1.508	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	155	7.656	33.110	97.958	-97.958	1.0313	263.76	1	244.895	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	155	6.617	0.000	0.000	0.000	1.0313	20.20	1	20.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	156	6.864	14.213	87.819	-87.819	1.0255	236.46	1	219.548	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	156	3.177	0.000	0.000	0.000	1.0255	9.70	1	9.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	157	10.232	1.928	7.103	-7.103	1.0168	19.12	1	17.757	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	158	2.207	0.619	1.532	-1.532	1.0277	4.12	1	3.829	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	158	1.982	10.250	25.351	-25.351	1.0277	68.26	1	63.378	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	158	0.000	0.000	3.441	-3.441	1.0277	9.26	0	8.602	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	159	4.507	1.967	3.129	-3.129	1.0294	8.42	1	7.822	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	159	5.029	40.451	64.347	-64.347	1.0294	173.26	1	160.868	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	159	0.884	0.000	0.000	0.000	1.0294	2.70	1	2.700	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	159	0.000	0.000	2.819	-2.819	1.0294	7.59	0	7.048	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	160	14.779	1.794	10.259	-10.259	1.0319	27.62	1	25.649	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	160	5.761	12.890	73.706	-73.706	1.0319	198.46	1	184.265	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	160	18.114	0.000	0.000	0.000	1.0319	55.30	1	55.300	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	161	6.655	15.606	85.145	-85.145	1.0210	229.26	1	212.863	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	162	32.113	7.998	22.292	-22.292	1.0135	60.02	1	55.731	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	162	1.392	6.391	17.812	-17.812	1.0135	47.96	1	44.530	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	162	1.048	0.000	0.000	0.000	1.0135	3.20	1	3.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	163	6.429	7.682	82.248	-82.248	1.0234	221.46	1	205.620	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	163	2.358	0.000	0.000	0.000	1.0234	7.20	1	7.200	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	164	4.422	0.000	0.000	0.000	1.0258	13.50	1	13.500	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	164	0.000	0.000	29.475	-29.475	1.0258	79.36	0	73.687	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	165	2.330	4.621	29.808	-29.808	1.0073	80.26	1	74.520	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	165	6.911	0.000	0.000	0.000	1.0073	21.10	1	21.100	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	166	10.927	1.563	7.585	-7.585	1.0240	20.42	1	18.964	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	166	6.966	18.364	89.119	-89.119	1.0240	239.96	1	222.797	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	166	0.000	0.000	3.497	-3.497	1.0240	9.42	0	8.742	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	167	1.190	-0.059	0.826	-0.826	1.0080	2.22	1	2.065	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	167	3.543	-3.210	45.332	-45.332	1.0080	122.06	1	113.330	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	167	12.218	0.000	0.000	0.000	1.0080	37.30	1	37.300	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	168	3.170	-0.260	2.200	-2.200	1.0264	5.92	1	5.501	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	168	0.000	0.000	3.441	-3.441	1.0264	9.26	0	8.602	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	169	4.594	34.624	58.776	-58.776	1.0269	158.26	1	146.941	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	169	0.000	0.000	4.229	-4.229	1.0269	11.39	0	10.573	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	170	2.870	19.495	36.716	-36.716	1.0198	98.86	1	91.789	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	170	1.310	0.000	0.000	0.000	1.0198	4.00	1	4.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	171	0.347	0.000	0.000	0.000	1.0254	1.06	1	1.060	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	171	0.000	0.000	7.879	-7.879	1.0254	21.22	0	19.698	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	172	1.720	1.053	22.009	-22.009	1.0074	59.26	1	55.022	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	172	10.940	0.000	0.000	0.000	1.0074	33.40	1	33.400	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	173	30.000	0.734	15.000	-12.000	1.0378	33.54	1	30.000	15.000	0	0	0	0	0	0	0	0	0	0	0	;
	173	30.000	0.734	15.000	-12.000	1.0378	33.54	1	30.000	15.000	0	0	0	0	0	0	0	0	0	0	0	;
	173	30.000	0.734	15.000	-12.000	1.0378	33.54	1	30.000	15.000	0	0	0	0	0	0	0	0	0	0	0	;
	173	54.000	1.321	27.000	-21.600	1.0378	60.37	1	54.000	27.000	0	0	0	0	0	0	0	0	0	0	0	;
	174	16.000	1.709	10.500	-8.400	1.0367	23.48	1	21.000	10.500	0	0	0	0	0	0	0	0	0	0	0	;
	174	0.000	0.000	10.500	-8.400	1.0367	23.48	0	21.000	10.500	0	0	0	0	0	0	0	0	0	0	0	;
	175	0.000	0.000	27.000	-21.600	1.0083	60.37	0	54.000	27.000	0	0	0	0	0	0	0	0	0	0	0	;
	175	0.000	0.000	27.000	-21.600	1.0083	60.37	0	54.000	27.000	0	0	0	0	0	0	0	0	0	0	0	;
	176	16.000	0.507	11.000	-8.800	1.0082	24.60	1	22.000	11.000	0	0	0	0	0	0	0	0	0	0	0	;
	176	0.000	0.000	11.000	-8.800	1.0082	24.60	0	22.000	11.000	0	0	0	0	0	0	0	0	0	0	0	;
	177	26.000	-0.040	17.000	-13.600	1.0391	38.01	1	34.000	-34.000	0	0	0	0	0	0	0	0	0	0	0	;
	177	0.000	0.000	17.000	-13.600	1.0391	38.01	0	34.000	-34.000	0	0	0	0	0	0	0	0	0	0	0	;
	178	28.000	0.607	14.500	-11.600	1.0260	32.42	1	29.000	14.500	0	0	0	0	0	0	0	0	0	0	0	;
	178	28.000	0.607	14.500	-11.600	1.0260	32.42	1	29.000	14.500	0	0	0	0	0	0	0	0	0	0	0	;
	179	54.000	2.971	31.250	-25.000	1.0364	69.88	1	62.500	31.250	0	0	0	0	0	0	0	0	0	0	0	;
	179	0.000	0.000	31.250	-25.000	1.0364	69.88	0	62.500	-62.500	0	0	0	0	0	0	0	0	0	0	0	;
	181	41.000	-0.613	22.000	-17.600	1.0262	49.19	1	44.000	22.000	0	0	0	0	0	0	0	0	0	0	0	;
	181	41.000	-0.613	22.000	-17.600	1.0262	49.19	1	44.000	22.000	0	0	0	0	0	0	0	0	0	0	0	;
	181	41.000	-0.613	22.000	-17.600	1.0262	49.19	1	44.000	22.000	0	0	0	0	0	0	0	0	0	0	0	;
	182	68.000	2.691	47.750	-38.200	1.0373	106.77	1	95.500	-95.500	0	0	0	0	0	0	0	0	0	0	0	;
	182	67.000	2.691	47.750	-38.200	1.0373	106.77	1	95.500	-95.500	0	0	0	0	0	0	0	0	0	0	0	;
	187	0.000	0.000	26.500	-21.200	1.0183	59.26	0	53.000	26.500	0	0	0	0	0	0	0	0	0	0	0	;
	188	0.000	0.000	26.500	-21.200	1.0183	59.26	0	53.000	26.500	0	0	0	0	0	0	0	0	0	0	0	;
	189	0.000	0.000	26.500	-21.200	1.0183	59.26	0	53.000	26.500	0	0	0	0	0	0	0	0	0	0	0	;
	191	60.000	-2.480	30.000	-24.000	1.0484	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	191	60.000	-2.480	30.000	-24.000	1.0484	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	191	60.000	-2.480	30.000	-24.000	1.0484	67.08	1	60.000	30.000	0	0	0	0	0	0	0	0	0	0	0	;
	191	140.000	-7.813	94.500	-75.600	1.0484	211.31	1	189.000	94.500	0	0	0	0	0	0	0	0	0	0	0	;
	192	65.000	4.339	40.000	-32.000	1.0429	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	192	65.000	4.339	40.000	-32.000	1.0429	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	192	65.000	4.339	40.000	-32.000	1.0429	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	194	79.000	7.130	40.000	-32.000	1.0412	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	194	78.000	7.130	40.000	-32.000	1.0412	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	194	0.000	0.000	40.000	-32.000	1.0412	89.44	0	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	195	74.000	4.993	56.000	-44.800	1.0296	125.22	1	112.000	-112.000	0	0	0	0	0	0	0	0	0	0	0	;
	195	74.000	4.993	56.000	-44.800	1.0296	125.22	1	112.000	-112.000	0	0	0	0	0	0	0	0	0	0	0	;
	195	0.000	0.000	56.000	-44.800	1.0296	125.22	0	112.000	-112.000	0	0	0	0	0	0	0	0	0	0	0	;
	196	57.000	4.239	31.000	-24.800	1.0462	69.32	1	62.000	31.000	0	0	0	0	0	0	0	0	0	0	0	;
	196	56.000	4.239	31.000	-24.800	1.0462	69.32	1	62.000	31.000	0	0	0	0	0	0	0	0	0	0	0	;
	196	56.000	4.239	31.000	-24.800	1.0462	69.32	1	62.000	31.000	0	0	0	0	0	0	0	0	0	0	0	;
	198	75.000	-3.923	38.250	-30.600	1.0477	85.53	1	76.500	-76.500	0	0	0	0	0	0	0	0	0	0	0	;
	198	75.000	-3.923	38.250	-30.600	1.0477	85.53	1	76.500	-76.500	0	0	0	0	0	0	0	0	0	0	0	;
	200	50.000	4.048	32.500	-26.000	1.0462	72.67	1	65.000	32.500	0	0	0	0	0	0	0	0	0	0	0	;
	201	50.000	4.048	32.500	-26.000	1.0462	72.67	1	65.000	32.500	0	0	0	0	0	0	0	0	0	0	0	;
	202	50.000	4.048	32.500	-26.000	1.0462	72.67	1	65.000	32.500	0	0	0	0	0	0	0	0	0	0	0	;
	203	210.000	-17.825	122.500	-98.000	1.0462	273.92	1	245.000	122.500	0	0	0	0	0	0	0	0	0	0	0	;
	206	63.000	7.835	35.000	-28.000	1.0295	78.26	1	70.000	35.000	0	0	0	0	0	0	0	0	0	0	0	;
	207	63.000	6.525	35.000	-28.000	1.0295	78.26	1	70.000	35.000	0	0	0	0	0	0	0	0	0	0	0	;
	218	53.000	6.788	33.500	-26.800	1.0308	74.91	1	67.000	33.500	0	0	0	0	0	0	0	0	0	0	0	;
	218	53.000	6.788	33.500	-26.800	1.0308	74.91	1	67.000	33.500	0	0	0	0	0	0	0	0	0	0	0	;
	218	53.000	6.788	33.500	-26.800	1.0308	74.91	1	67.000	33.500	0	0	0	0	0	0	0	0	0	0	0	;
	222	282.000	23.952	235.200	-117.600	1.0225	457.15	1	392.000	235.200	0	0	0	0	0	0	0	0	0	0	0	;
	225	174.000	-30.695	95.500	-76.400	1.0485	213.54	1	191.000	95.500	0	0	0	0	0	0	0	0	0	0	0	;
	227	0.000	0.000	60.000	-48.000	1.0413	134.16	0	120.000	-120.000	0	0	0	0	0	0	0	0	0	0	0	;
	227	106.000	-28.205	60.000	-48.000	1.0413	134.16	1	120.000	-120.000	0	0	0	0	0	0	0	0	0	0	0	;
	228	104.000	-28.290	64.000	-51.200	1.0413	143.11	1	128.000	-128.000	0	0	0	0	0	0	0	0	0	0	0	;
	228	105.000	-28.290	64.000	-51.200	1.0413	143.11	1	128.000	-128.000	0	0	0	0	0	0	0	0	0	0	0	;
	229	0.000	0.000	195.000	-156.000	1.0434	436.03	0	390.000	-390.000	0	0	0	0	0	0	0	0	0	0	0	;
	229	0.000	0.000	195.000	-156.000	1.0434	436.03	0	390.000	-390.000	0	0	0	0	0	0	0	0	0	0	0	;
	230	136.000	28.014	110.000	-88.000	1.0439	245.97	1	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	231	129.000	-8.288	65.250	-52.200	1.0471	145.90	1	130.500	-130.500	0	0	0	0	0	0	0	0	0	0	0	;
	231	0.000	0.000	65.250	-52.200	1.0471	145.90	0	130.500	-130.500	0	0	0	0	0	0	0	0	0	0	0	;
	232	0.000	0.000	157.500	-126.000	1.0464	352.18	0	315.000	157.500	0	0	0	0	0	0	0	0	0	0	0	;
	233	271.000	15.964	157.500	-126.000	1.0464	352.18	1	315.000	157.500	0	0	0	0	0	0	0	0	0	0	0	;
	239	274.911	-71.656	235.200	-117.600	1.0418	457.15	1	392.000	235.200	0	0	0	0	0	0	0	0	0	0	0	;
	240	280.000	-30.971	235.200	-117.600	1.0418	457.15	1	392.000	235.200	0	0	0	0	0	0	0	0	0	0	0	;
	241	350.000	8.836	247.800	-123.900	1.0472	481.64	1	413.000	247.800	0	0	0	0	0	0	0	0	0	0	0	;
	242	350.000	10.018	247.800	-123.900	1.0470	481.64	1	413.000	247.800	0	0	0	0	0	0	0	0	0	0	0	;
	243	350.000	-58.531	251.100	-125.550	1.0451	488.05	1	418.500	251.100	0	0	0	0	0	0	0	0	0	0	0	;
	244	350.000	-43.914	251.100	-125.550	1.0451	488.05	1	418.500	251.100	0	0	0	0	0	0	0	0	0	0	0	;
	250	27.673	-5.612	19.210	-19.210	1.0346	51.72	1	48.025	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	251	3.474	3.581	44.441	-44.441	1.0279	119.66	1	111.102	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	252	5.407	-3.560	69.175	-69.175	1.0205	186.26	1	172.938	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	253	3.723	2.524	47.635	-47.635	1.0196	128.26	1	119.086	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	254	7.654	-0.659	97.921	-97.921	1.0308	263.66	1	244.802	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	255	109.206	-6.178	75.810	-75.810	1.0357	204.12	1	189.525	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	262	7.088	5.117	90.679	-90.679	1.0281	244.16	1	226.697	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	263	4.025	-6.551	51.497	-51.497	1.0285	138.66	1	128.743	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	264	8.150	1.805	104.272	-104.272	1.0286	280.76	1	260.679	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	265	3.340	12.817	42.732	-42.732	1.0273	115.06	1	106.831	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	266	4.228	-16.578	54.097	-54.097	1.0290	145.66	1	135.242	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	267	5.389	2.189	68.952	-68.952	1.0305	185.66	1	172.381	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	268	4.704	8.623	60.188	-60.188	1.0459	162.06	1	150.469	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	273	34.000	3.198	19.500	-15.600	1.0309	43.60	1	39.000	19.500	0	0	0	0	0	0	0	0	0	0	0	;
	273	34.000	3.198	19.500	-15.600	1.0309	43.60	1	39.000	19.500	0	0	0	0	0	0	0	0	0	0	0	;
	273	34.000	3.198	19.500	-15.600	1.0309	43.60	1	39.000	19.500	0	0	0	0	0	0	0	0	0	0	0	;
	293	102.000	-16.387	60.000	-60.000	1.0333	161.55	1	150.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	293	4.779	0.000	0.000	0.000	1.0333	50.00	1	50.000	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	309	0.000	0.000	58.660	-58.660	1.0300	157.95	0	146.651	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	311	153.000	7.427	138.750	-111.000	1.0465	310.25	1	277.500	-277.500	0	0	0	0	0	0	0	0	0	0	0	;
	311	0.000	0.000	138.750	-111.000	1.0465	310.25	0	277.500	-277.500	0	0	0	0	0	0	0	0	0	0	0	;
	313	0.000	0.000	70.392	-70.392	1.0481	189.54	0	175.981	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	314	0.000	0.000	81.468	-81.468	1.0366	219.36	0	203.670	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	315	0.000	0.000	46.928	-46.928	1.0472	126.36	0	117.321	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	316	0.000	0.000	70.392	-70.392	1.0483	189.54	0	175.981	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	40.000	-4.296	28.500	-22.800	1.0486	63.73	1	57.000	28.500	0	0	0	0	0	0	0	0	0	0	0	;
	317	0.000	0.000	28.500	-22.800	1.0486	63.73	0	57.000	28.500	0	0	0	0	0	0	0	0	0	0	0	;
	317	191.000	-16.582	110.000	-88.000	1.0486	245.97	1	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	191.000	-16.582	110.000	-88.000	1.0486	245.97	1	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	0.000	0.000	110.000	-88.000	1.0486	245.97	0	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	0.000	0.000	110.000	-88.000	1.0486	245.97	0	220.000	-220.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	49.000	-6.030	40.000	-32.000	1.0486	89.44	1	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	317	0.000	0.000	40.000	-32.000	1.0486	89.44	0	80.000	40.000	0	0	0	0	0	0	0	0	0	0	0	;
	319	0.811	2.737	10.380	-10.380	1.0275	27.95	1	25.951	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	320	0.000	0.000	29.675	-29.675	1.0300	79.90	0	74.188	0.000	0	0	0	0	0	0	0	0	0	0	0	;
	321	0.000	0.000	16.425	-16.425	1.0249	44.23	0	41.062	0.000	0	0	0	0	0	0	0	0	0	0	0	;
];

%% gen tags 
% Generation Technology Type:
%  CWS (Connection with Spain),
%  FOG (Fossil Gas),
%  FHC (Fossil Hard Coal),
%  HWR (Hydro Water Reservoir),
%  HPS (Hydro Pumped Storage),
%  HRP (Hydro Run-of-river and poundage),
%  SH1 (Small Hydro - P ≤ 10 MW),
%  SH3 (Small Hydro - 10 MW < P ≤ 30 MW),
%  PVP (Photovoltaic power plant),
%  WON (Wind onshore),
%  WOF (Wind offshore),
%  MAR (Marine),
%  OTH (Other thermal, such as geothermal, biomass, biogas, Municipal solid waste and CHP renewable and non-renewable)
%	genType
mpc.gen_tags = {
	'CWS';	'CWS';	'CWS';	'CWS';	'CWS';	'CWS';	'CWS';	'CWS';	'PVP';	'PVP';	'PVP';	'PVP';	'PVP';	'PVP';	'HWR';	'HWR';	'PVP';	'HRP';	'HRP';	'HRP';	'PVP';	'WON';	'WON';	'PVP';	'PVP';	'WON';	'SH3';	'HRP';	'HRP';	'OTH';	'WON';	'SH1';	'PVP';	'OTH';	'PVP';	'OTH';	'OTH';	'PVP';	'OTH';	'SH1';	'PVP';	'OTH';	'WON';	'SH1';	'SH3';	'PVP';	'HPS';	'HPS';	'OTH';	'WON';	'SH1';	'OTH';	'SH1';	'PVP';	'OTH';	'PVP';	'OTH';	'WON';	'SH1';	'SH3';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'PVP';	'WON';	'SH1';	'PVP';	'OTH';	'WON';	'PVP';	'OTH';	'PVP';	'OTH';	'WON';	'SH1';	'WON';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'SH3';	'PVP';	'OTH';	'WON';	'SH1';	'PVP';	'HWR';	'OTH';	'WON';	'SH1';	'OTH';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'OTH';	'PVP';	'WON';	'OTH';	'PVP';	'OTH';	'WON';	'SH1';	'OTH';	'SH1';	'PVP';	'OTH';	'PVP';	'SH1';	'PVP';	'OTH';	'PVP';	'OTH';	'WON';	'SH1';	'PVP';	'OTH';	'WON';	'OTH';	'WON';	'PVP';	'OTH';	'PVP';	'OTH';	'PVP';	'HWR';	'HRP';	'HRP';	'HRP';	'HRP';	'HWR';	'HWR';	'OTH';	'WON';	'SH1';	'PVP';	'OTH';	'SH1';	'PVP';	'OTH';	'WON';	'SH1';	'SH3';	'PVP';	'WON';	'PVP';	'OTH';	'PVP';	'HWR';	'OTH';	'WON';	'SH1';	'WON';	'SH1';	'OTH';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'PVP';	'OTH';	'WON';	'SH1';	'WON';	'OTH';	'WON';	'SH1';	'WON';	'SH1';	'SH1';	'PVP';	'WON';	'SH1';	'OTH';	'WON';	'PVP';	'OTH';	'WON';	'SH1';	'OTH';	'PVP';	'WON';	'PVP';	'WON';	'SH1';	'SH1';	'PVP';	'WON';	'SH1';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HWR';	'HPS';	'HPS';	'HWR';	'HWR';	'HWR';	'HPS';	'HRP';	'HRP';	'HRP';	'HPS';	'HPS';	'HWR';	'HWR';	'HWR';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HPS';	'HPS';	'HPS';	'HRP';	'HRP';	'HRP';	'HPS';	'HPS';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'HRP';	'FOG';	'HRP';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HPS';	'HWR';	'HWR';	'FOG';	'FOG';	'FOG';	'FOG';	'FOG';	'FOG';	'OTH';	'WON';	'WON';	'WON';	'WON';	'OTH';	'WON';	'WON';	'WON';	'WON';	'WON';	'WON';	'WON';	'HRP';	'HRP';	'HRP';	'WOF';	'MAR';	'PVP';	'HPS';	'HPS';	'PVP';	'PVP';	'PVP';	'PVP';	'HWR';	'HWR';	'HPS';	'HPS';	'HPS';	'HPS';	'HWR';	'HWR';	'WON';	'PVP';	'PVP';
};

%% branch data
% If the 'step_size', 'actTap', 'minTap', 'maxTap' and 'normalTap' fields are equal to "-1", it means that the transformer does not have tap changing capability
% If the length is equal to "0", it means that the correspondent branch represents a transformer
%	fbus	tbus	r	x	b	rateA (summer)	rateB (spring)	rateC (winter)	tap ratio	shift angle		status	angmin	angmax	step_size	actTap	minTap	maxTap	normalTap	length (km)
mpc.branch = [
	8	24	0.02945	0.09879	0.03302	91	123	130	0	0	0	-360	360	0	0	0	0	0	54.0	;
	8	176	0.02007	0.06867	0.02205	96	104	104	0	0	1	-360	360	0	0	0	0	0	36.6	;
	8	176	0.02014	0.06872	0.02229	96	104	104	0	0	1	-360	360	0	0	0	0	0	36.7	;
	9	14	0.00146	0.00787	0.00265	255	260	260	0	0	1	-360	360	0	0	0	0	0	4.3	;
	9	14	0.00146	0.00769	0.00260	255	260	260	0	0	1	-360	360	0	0	0	0	0	4.2	;
	9	14	0.00137	0.00737	0.00250	124	162	203	0	0	1	-360	360	0	0	0	0	0	4.1	;
	10	19	0.02098	0.11168	0.03801	218	248	260	0	0	1	-360	360	0	0	0	0	0	61.3	;
	10	22	0.02445	0.08166	0.02747	164	186	206	0	0	1	-360	360	0	0	0	0	0	44.5	;
	10	26	0.00777	0.04761	0.01640	260	260	260	0	0	1	-360	360	0	0	0	0	0	26.0	;
	11	14	0.02030	0.07019	0.02214	171	186	206	0	0	1	-360	360	0	0	0	0	0	36.7	;
	11	14	0.02010	0.06862	0.02204	191	204	222	0	0	1	-360	360	0	0	0	0	0	36.5	;
	12	22	0.02823	0.10553	0.04049	189	204	222	0	0	1	-360	360	0	0	0	0	0	61.6	;
	12	23	0.01953	0.08771	0.03214	195	204	222	0	0	1	-360	360	0	0	0	0	0	49.8	;
	12	29	0.01515	0.04945	0.01745	195	204	222	0	0	1	-360	360	0	0	0	0	0	27.9	;
	12	29	0.01515	0.04945	0.01745	195	204	222	0	0	1	-360	360	0	0	0	0	0	27.9	;
	12	29	0.00551	0.05765	0.03609	260	260	260	0	0	1	-360	360	0	0	0	0	0	42.8	;
	12	34	0.02334	0.12013	0.04435	255	260	260	0	0	1	-360	360	0	0	0	0	0	68.7	;
	13	14	0.00788	0.04049	0.01506	255	260	260	0	0	1	-360	360	0	0	0	0	0	23.1	;
	13	14	0.00788	0.04049	0.01506	255	260	260	0	0	1	-360	360	0	0	0	0	0	23.1	;
	13	20	0.00745	0.02441	0.00855	195	204	221	0	0	1	-360	360	0	0	0	0	0	13.6	;
	13	20	0.00745	0.02441	0.00855	195	204	221	0	0	1	-360	360	0	0	0	0	0	13.6	;
	13	20	0.00745	0.02441	0.00855	195	204	221	0	0	1	-360	360	0	0	0	0	0	13.6	;
	13	20	0.00745	0.02441	0.00855	195	204	221	0	0	1	-360	360	0	0	0	0	0	13.6	;
	13	180	0.00411	0.02110	0.00788	255	260	260	0	0	1	-360	360	0	0	0	0	0	12.0	;
	13	246	0.00422	0.02163	0.00811	260	260	260	0	0	1	-360	360	0	0	0	0	0	12.2	;
	14	180	0.00411	0.02110	0.00788	255	260	260	0	0	1	-360	360	0	0	0	0	0	12.0	;
	14	185	0.01114	0.03788	0.01266	191	204	222	0	0	1	-360	360	0	0	0	0	0	20.5	;
	14	186	0.02662	0.09054	0.02905	185	204	222	0	0	1	-360	360	0	0	0	0	0	48.4	;
	14	246	0.00408	0.02092	0.00779	255	260	260	0	0	1	-360	360	0	0	0	0	0	12.0	;
	15	22	0.02154	0.10932	0.04126	224	248	260	0	0	1	-360	360	0	0	0	0	0	63.4	;
	15	22	0.02154	0.10932	0.04126	224	248	260	0	0	1	-360	360	0	0	0	0	0	63.4	;
	15	26	0.00974	0.05968	0.02055	260	260	260	0	0	1	-360	360	0	0	0	0	0	32.6	;
	15	27	0.02701	0.09576	0.03037	191	204	222	0	0	1	-360	360	0	0	0	0	0	50.5	;
	15	28	0.03335	0.10915	0.03827	195	204	222	0	0	1	-360	360	0	0	0	0	0	60.7	;
	15	29	0.05251	0.17172	0.06032	195	204	222	0	0	1	-360	360	0	0	0	0	0	95.6	;
	15	250	0.00184	0.00954	0.00342	130	130	130	0	0	1	-360	360	0	0	0	0	0	5.4	;
	15	250	0.00187	0.00974	0.00349	130	130	130	0	0	1	-360	360	0	0	0	0	0	5.5	;
	15	255	0.00282	0.01157	0.02727	260	273	296	0	0	1	-360	360	0	0	0	0	0	5.9	;
	16	178	0.00839	0.03586	0.01167	104	123	130	0	0	1	-360	360	0	0	0	0	0	19.0	;
	17	21	0.01658	0.06789	0.02323	195	204	222	0	0	1	-360	360	0	0	0	0	0	37.9	;
	17	21	0.00900	0.05720	0.02480	260	273	296	0	0	1	-360	360	0	0	0	0	0	35.0	;
	17	25	0.01638	0.06453	0.02191	104	123	153	0	0	1	-360	360	0	0	0	0	0	35.2	;
	17	184	0.01106	0.03018	0.01032	91	108	134	0	0	1	-360	360	0	0	0	0	0	16.6	;
	18	287	0.00156	0.01068	0.00498	260	273	296	0	0	0	-360	360	0	0	0	0	0	6.8	;
	18	288	0.00151	0.01038	0.00484	260	273	296	0	0	1	-360	360	0	0	0	0	0	6.6	;
	18	306	0.00548	0.02813	0.01051	255	260	260	0	0	1	-360	360	0	0	0	0	0	16.0	;
	18	307	0.00480	0.02461	0.00920	255	260	260	0	0	1	-360	360	0	0	0	0	0	14.0	;
	19	186	0.02662	0.09054	0.02905	185	204	222	0	0	1	-360	360	0	0	0	0	0	48.4	;
	21	30	0.01441	0.06067	0.02080	195	204	222	0	0	1	-360	360	0	0	0	0	0	33.3	;
	21	32	0.00720	0.04579	0.01985	260	273	296	0	0	1	-360	360	0	0	0	0	0	28.0	;
	21	32	0.00720	0.04579	0.01985	260	273	296	0	0	1	-360	360	0	0	0	0	0	28.0	;
	21	251	0.00610	0.04180	0.01950	260	273	296	0	0	1	-360	360	0	0	0	0	0	26.5	;
	22	34	0.01325	0.06238	0.06238	337	372	411	0	0	1	-360	360	0	0	0	0	0	57.9	;
	22	245	0.01212	0.04116	0.01324	81	123	130	0	0	1	-360	360	0	0	0	0	0	22.0	;
	23	34	0.01185	0.06135	0.02247	255	260	260	0	0	1	-360	360	0	0	0	0	0	35.1	;
	23	34	0.01185	0.06135	0.02247	255	260	260	0	0	1	-360	360	0	0	0	0	0	35.1	;
	23	34	0.01580	0.07475	0.02730	255	260	260	0	0	1	-360	360	0	0	0	0	0	42.7	;
	24	31	0.00310	0.03271	0.07540	520	520	520	0	0	1	-360	360	0	0	0	0	0	46.5	;
	24	181	0.00436	0.01464	0.00484	189	195	195	0	0	1	-360	360	0	0	0	0	0	7.8	;
	24	248	0.00715	0.03705	0.01350	227	248	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	24	248	0.00715	0.03705	0.01350	227	248	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	24	252	0.01240	0.06509	0.02314	253	260	260	0	0	1	-360	360	0	0	0	0	0	36.3	;
	25	32	0.01065	0.03476	0.01219	195	204	222	0	0	1	-360	360	0	0	0	0	0	19.3	;
	25	32	0.01069	0.03488	0.01223	195	204	222	0	0	1	-360	360	0	0	0	0	0	19.3	;
	25	32	0.00504	0.02690	0.01516	233	248	260	0	0	1	-360	360	0	0	0	0	0	18.0	;
	25	307	0.00582	0.01853	0.00675	104	123	153	0	0	1	-360	360	0	0	0	0	0	10.6	;
	25	307	0.00581	0.01846	0.00677	104	123	153	0	0	1	-360	360	0	0	0	0	0	10.6	;
	27	185	0.01114	0.03788	0.01266	191	204	222	0	0	1	-360	360	0	0	0	0	0	20.5	;
	28	29	0.01921	0.06275	0.02210	195	204	222	0	0	1	-360	360	0	0	0	0	0	35.2	;
	30	32	0.00729	0.02383	0.00834	195	204	222	0	0	1	-360	360	0	0	0	0	0	13.2	;
	30	32	0.00729	0.02383	0.00834	195	204	222	0	0	1	-360	360	0	0	0	0	0	13.2	;
	30	32	0.00732	0.02829	0.00946	195	204	222	0	0	1	-360	360	0	0	0	0	0	15.4	;
	30	33	0.00260	0.02724	0.01640	520	520	520	0	0	1	-360	360	0	0	0	0	0	19.8	;
	30	174	0.00358	0.02407	0.00900	260	260	260	0	0	1	-360	360	0	0	0	0	0	13.8	;
	30	179	0.00403	0.01370	0.00440	104	123	153	0	0	1	-360	360	0	0	0	0	0	7.3	;
	30	184	0.01106	0.03018	0.01032	91	108	134	0	0	1	-360	360	0	0	0	0	0	16.6	;
	31	248	0.00715	0.03705	0.01350	227	248	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	31	248	0.00715	0.03705	0.01350	227	248	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	31	253	0.01091	0.05722	0.02036	253	260	260	0	0	1	-360	360	0	0	0	0	0	31.9	;
	32	33	0.00695	0.04818	0.02461	504	520	520	0	0	1	-360	360	0	0	0	0	0	32.2	;
	32	254	0.01869	0.10188	0.03320	260	273	296	0	0	1	-360	360	0	0	0	0	0	53.5	;
	32	254	0.01869	0.10188	0.03320	260	273	296	0	0	1	-360	360	0	0	0	0	0	53.5	;
	32	306	0.01351	0.04810	0.01561	195	204	222	0	0	1	-360	360	0	0	0	0	0	25.7	;
	33	173	0.00082	0.00526	0.00200	306	321	348	0	0	1	-360	360	0	0	0	0	0	3.0	;
	33	177	0.00830	0.02880	0.00938	104	104	104	0	0	1	-360	360	0	0	0	0	0	15.3	;
	33	182	0.00023	0.00161	0.00056	306	321	348	0	0	1	-360	360	0	0	0	0	0	0.9	;
	33	184	0.00504	0.03382	0.01267	274	291	322	0	0	1	-360	360	0	0	0	0	0	19.3	;
	36	64	0.00418	0.02292	0.13770	999	1092	1206	0	0	1	-360	360	0	0	0	0	0	52.3	;
	36	71	0.00396	0.02133	0.13035	999	1092	1206	0	0	1	-360	360	0	0	0	0	0	48.9	;
	36	187	0.00011	0.00060	0.00094	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.7	;
	36	188	0.00018	0.00061	0.00092	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.7	;
	36	189	0.00018	0.00061	0.00092	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.8	;
	37	59	0.00168	0.00382	0.35975	493	493	493	0	0	1	-360	360	0	0	0	0	0	10.4	;
	37	213	0.00017	0.00044	0.04927	322	322	322	0	0	1	-360	360	0	0	0	0	0	1.8	;
	37	214	0.00017	0.00044	0.04927	322	322	322	0	0	1	-360	360	0	0	0	0	0	1.8	;
	37	215	0.00017	0.00044	0.04927	322	322	322	0	0	1	-360	360	0	0	0	0	0	1.8	;
	37	216	0.00017	0.00044	0.04927	322	322	322	0	0	1	-360	360	0	0	0	0	0	1.8	;
	38	208	0.00048	0.00109	0.10268	493	493	493	0	0	1	-360	360	0	0	0	0	0	3.2	;
	38	209	0.00048	0.00108	0.10056	493	493	493	0	0	1	-360	360	0	0	0	0	0	3.2	;
	39	45	0.01696	0.09185	0.14133	381	381	381	0	0	1	-360	360	0	0	0	0	0	106.8	;
	39	69	0.00691	0.03721	0.05799	513	546	571.5	0	0	1	-360	360	0	0	0	0	0	43.0	;
	39	69	0.00687	0.03725	0.05671	381	381	381	0	0	1	-360	360	0	0	0	0	0	43.0	;
	39	71	0.00183	0.01006	0.05957	1026	1090.5	1143	0	0	1	-360	360	0	0	0	0	0	22.2	;
	39	78	0.00658	0.03647	0.05332	382	400	435	0	0	1	-360	360	0	0	0	0	0	41.1	;
	39	195	0.00484	0.02634	0.04046	199	237	297	0	0	1	-360	360	0	0	0	0	0	30.4	;
	39	199	0.00873	0.04861	0.07070	381	381	381	0	0	1	-360	360	0	0	0	0	0	54.7	;
	39	258	0.00326	0.01810	0.02629	382	400	435	0	0	1	-360	360	0	0	0	0	0	20.3	;
	39	258	0.00240	0.01307	0.02007	199	237	297	0	0	1	-360	360	0	0	0	0	0	15.1	;
	40	51	0.00874	0.04843	0.07272	374	400	435	0	0	1	-360	360	0	0	0	0	0	54.7	;
	40	65	0.00985	0.05518	0.07982	499.5	546	571.5	0	0	1	-360	360	0	0	0	0	0	61.9	;
	40	65	0.00944	0.05439	0.07975	499.5	546	571.5	0	0	1	-360	360	0	0	0	0	0	61.8	;
	40	196	0.00017	0.00091	0.00135	182	237	297	0	0	1	-360	360	0	0	0	0	0	1.0	;
	40	198	0.00214	0.01565	0.02877	439	471	511	0	0	1	-360	360	0	0	0	0	0	19.6	;
	40	5	0.00630	0.03584	0.05497	374	400	435	0	0	1	-360	360	0	0	0	0	0	41.1	;
	40	5	0.00636	0.03628	0.05564	374	400	435	0	0	1	-360	360	0	0	0	0	0	41.4	;
	40	6	0.00481	0.02670	0.03939	360	390	430	0	0	1	-360	360	0	0	0	0	0	30.2	;
	41	53	0.00145	0.00845	0.01465	381	381	381	0	0	1	-360	360	0	0	0	0	0	10.4	;
	41	53	0.00078	0.00546	0.00902	381	381	381	0	0	1	-360	360	0	0	0	0	0	6.5	;
	41	57	0.00318	0.01660	0.02798	381	381	381	0	0	1	-360	360	0	0	0	0	0	20.2	;
	41	68	0.00084	0.00572	0.00995	401	426	472	0	0	1	-360	360	0	0	0	0	0	7.0	;
	41	68	0.00170	0.00386	0.36133	493	493	493	0	0	1	-360	360	0	0	0	0	0	10.7	;
	41	210	0.00056	0.00586	0.01715	762	762	762	0	0	1	-360	360	0	0	0	0	0	9.4	;
	41	211	0.00221	0.02313	0.06702	762	762	762	0	0	1	-360	360	0	0	0	0	0	37.0	;
	41	308	0.00006	0.00025	0.01708	240	240	240	0	0	1	-360	360	0	0	0	0	0	0.7	;
	42	78	0.00448	0.02493	0.03617	382	400	435	0	0	1	-360	360	0	0	0	0	0	28.0	;
	42	78	0.00448	0.02494	0.03619	382	400	435	0	0	1	-360	360	0	0	0	0	0	28.0	;
	42	257	0.00276	0.01543	0.02230	381	381	381	0	0	1	-360	360	0	0	0	0	0	17.3	;
	42	257	0.00274	0.01524	0.02237	381	381	381	0	0	1	-360	360	0	0	0	0	0	17.3	;
	43	58	0.00210	0.00476	0.44633	493	493	493	0	0	1	-360	360	0	0	0	0	0	12.6	;
	43	76	0.00113	0.00321	0.34652	446	446	446	0	0	1	-360	360	0	0	0	0	0	11.1	;
	43	76	0.00113	0.00320	0.34511	446	446	446	0	0	1	-360	360	0	0	0	0	0	11.1	;
	43	204	0.00146	0.00771	0.01235	381	381	381	0	0	1	-360	360	0	0	0	0	0	9.2	;
	43	205	0.00063	0.00332	0.00533	381	381	381	0	0	1	-360	360	0	0	0	0	0	3.9	;
	43	219	0.00083	0.00445	0.00676	342	364	381	0	0	1	-360	360	0	0	0	0	0	5.4	;
	44	48	0.00396	0.02139	0.03311	342	364	381	0	0	1	-360	360	0	0	0	0	0	24.9	;
	44	66	0.00779	0.04029	0.06834	381	381	381	0	0	1	-360	360	0	0	0	0	0	50.9	;
	44	66	0.00311	0.03080	0.09461	897	941	1021	0	0	1	-360	360	0	0	0	0	0	50.7	;
	44	193	0.00504	0.02686	0.04234	381	381	381	0	0	1	-360	360	0	0	0	0	0	31.7	;
	45	46	0.00650	0.03510	0.05270	382	400	435	0	0	1	-360	360	0	0	0	0	0	40.2	;
	45	46	0.00608	0.03139	0.05420	382	400	435	0	0	1	-360	360	0	0	0	0	0	38.8	;
	45	46	0.00614	0.03155	0.05417	382	400	435	0	0	1	-360	360	0	0	0	0	0	38.8	;
	45	74	0.00586	0.03263	0.04775	381	381	381	0	0	1	-360	360	0	0	0	0	0	36.7	;
	45	74	0.00586	0.03263	0.04775	381	381	381	0	0	1	-360	360	0	0	0	0	0	36.7	;
	45	199	0.00873	0.04861	0.07070	381	381	381	0	0	1	-360	360	0	0	0	0	0	54.7	;
	46	50	0.00409	0.02221	0.03328	381	400	435	0	0	1	-360	360	0	0	0	0	0	25.4	;
	46	64	0.00275	0.01510	0.09065	666	728	804	0	0	1	-360	360	0	0	0	0	0	34.8	;
	46	214	0.00477	0.02559	0.04001	381	381	381	0	0	1	-360	360	0	0	0	0	0	30.0	;
	46	216	0.00465	0.02524	0.03797	382	400	435	0	0	1	-360	360	0	0	0	0	0	28.9	;
	46	222	0.00006	0.00021	0.02068	438	438	438	0	0	1	-360	360	0	0	0	0	0	0.8	;
	46	260	0.00913	0.04888	0.07531	342	364	381	0	0	1	-360	360	0	0	0	0	0	56.8	;
	47	57	0.01028	0.05388	0.08954	381	381	381	0	0	1	-360	360	0	0	0	0	0	65.0	;
	47	61	0.00034	0.00182	0.00285	199	237	297	0	0	1	-360	360	0	0	0	0	0	2.1	;
	47	66	0.00525	0.02886	0.04430	381	381	381	0	0	1	-360	360	0	0	0	0	0	33.4	;
	47	67	0.00789	0.04153	0.06856	381	381	381	0	0	1	-360	360	0	0	0	0	0	50.0	;
	47	75	0.00724	0.03931	0.05957	382	400	435	0	0	1	-360	360	0	0	0	0	0	45.0	;
	47	211	0.00221	0.02313	0.06702	762	762	762	0	0	1	-360	360	0	0	0	0	0	37.0	;
	47	224	0.00039	0.00426	0.01070	750	762	762	0	0	1	-360	360	0	0	0	0	0	6.4	;
	48	66	0.01101	0.05739	0.09535	381	381	381	0	0	1	-360	360	0	0	0	0	0	69.5	;
	48	69	0.00352	0.01887	0.02971	513	546	571.5	0	0	1	-360	360	0	0	0	0	0	22.6	;
	48	69	0.00350	0.01889	0.02900	381	381	381	0	0	1	-360	360	0	0	0	0	0	22.0	;
	49	57	0.00169	0.00872	0.05960	381	381	381	0	0	1	-360	360	0	0	0	0	0	21.4	;
	49	193	0.00037	0.00490	0.01932	1200	1200	1200	0	0	1	-360	360	0	0	0	0	0	9.2	;
	49	221	0.00055	0.00728	0.02882	762	762	762	0	0	1	-360	360	0	0	0	0	0	13.7	;
	50	55	0.00311	0.01663	0.02615	381	381	381	0	0	1	-360	360	0	0	0	0	0	19.5	;
	50	55	0.00252	0.01377	0.02062	381	381	381	0	0	1	-360	360	0	0	0	0	0	15.8	;
	50	56	0.00162	0.01419	0.06090	762	762	762	0	0	1	-360	360	0	0	0	0	0	27.0	;
	50	204	0.00146	0.00771	0.01235	381	381	381	0	0	1	-360	360	0	0	0	0	0	9.2	;
	50	213	0.00210	0.01087	0.01848	381	381	381	0	0	1	-360	360	0	0	0	0	0	13.3	;
	50	215	0.00316	0.01718	0.02582	382	400	435	0	0	1	-360	360	0	0	0	0	0	19.7	;
	50	217	0.00182	0.00952	0.01558	382	400	435	0	0	1	-360	360	0	0	0	0	0	11.3	;
	51	66	0.00711	0.03753	0.06399	382	400	435	0	0	1	-360	360	0	0	0	0	0	45.9	;
	51	66	0.00712	0.03759	0.06408	382	400	435	0	0	1	-360	360	0	0	0	0	0	46.0	;
	51	194	0.00465	0.02422	0.04046	382	400	435	0	0	1	-360	360	0	0	0	0	0	29.4	;
	51	194	0.00466	0.02427	0.04055	382	400	435	0	0	1	-360	360	0	0	0	0	0	29.5	;
	51	224	0.00039	0.00426	0.01070	750	762	762	0	0	0	-360	360	0	0	0	0	0	6.4	;
	52	199	0.00057	0.00311	0.00469	191	191	191	0	0	1	-360	360	0	0	0	0	0	3.6	;
	53	68	0.00078	0.00545	0.00900	401	426	472	0	0	1	-360	360	0	0	0	0	0	6.6	;
	53	190	0.00222	0.01196	0.02035	381	381	381	0	0	1	-360	360	0	0	0	0	0	14.7	;
	54	63	0.00412	0.02158	0.03520	374	381	381	0	0	1	-360	360	0	0	0	0	0	25.7	;
	54	77	0.00631	0.03514	0.05182	374	400	435	0	0	1	-360	360	0	0	0	0	0	39.5	;
	54	77	0.00636	0.03898	0.06249	374	400	435	0	0	1	-360	360	0	0	0	0	0	46.1	;
	54	191	0.00237	0.01312	0.01925	182	229	229	0	0	1	-360	360	0	0	0	0	0	14.9	;
	54	191	0.00189	0.01296	0.02104	229	229	229	0	0	1	-360	360	0	0	0	0	0	15.5	;
	54	192	0.00309	0.01722	0.02516	374	400	435	0	0	1	-360	360	0	0	0	0	0	19.4	;
	54	200	0.00006	0.00035	0.00053	182	237	297	0	0	1	-360	360	0	0	0	0	0	0.4	;
	54	201	0.00006	0.00035	0.00053	182	237	297	0	0	1	-360	360	0	0	0	0	0	0.4	;
	54	202	0.00006	0.00035	0.00053	182	237	297	0	0	1	-360	360	0	0	0	0	0	0.4	;
	54	203	0.00005	0.00034	0.00053	182	237	297	0	0	1	-360	360	0	0	0	0	0	0.2	;
	55	58	0.00049	0.00177	0.22418	364	364	364	0	0	1	-360	360	0	0	0	0	0	7.8	;
	55	204	0.00041	0.00224	0.00340	381	381	381	0	0	1	-360	360	0	0	0	0	0	2.6	;
	55	205	0.00063	0.00332	0.00533	381	381	381	0	0	1	-360	360	0	0	0	0	0	3.9	;
	56	74	0.00719	0.04008	0.05857	382	400	435	0	0	1	-360	360	0	0	0	0	0	46.0	;
	56	205	0.00144	0.00779	0.01170	382	400	435	0	0	1	-360	360	0	0	0	0	0	8.9	;
	57	60	0.00351	0.01764	0.02842	381	381	381	0	0	1	-360	360	0	0	0	0	0	20.8	;
	57	67	0.00249	0.01299	0.02177	381	381	381	0	0	1	-360	360	0	0	0	0	0	15.7	;
	57	190	0.00222	0.01196	0.02035	381	381	381	0	0	1	-360	360	0	0	0	0	0	14.7	;
	57	210	0.00056	0.00586	0.01715	762	762	762	0	0	1	-360	360	0	0	0	0	0	9.4	;
	57	220	0.00042	0.00563	0.02152	1200	1200	1200	0	0	1	-360	360	0	0	0	0	0	10.4	;
	57	221	0.00055	0.00728	0.02882	762	762	762	0	0	1	-360	360	0	0	0	0	0	13.7	;
	58	219	0.00038	0.00138	0.17477	364	364	364	0	0	1	-360	360	0	0	0	0	0	6.2	;
	59	217	0.00204	0.00462	0.43235	493	493	493	0	0	1	-360	360	0	0	0	0	0	12.5	;
	60	66	0.00204	0.01097	0.01708	381	381	381	0	0	1	-360	360	0	0	0	0	0	12.8	;
	60	206	0.00004	0.00020	0.00031	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.2	;
	60	207	0.00004	0.00024	0.00036	191	191	191	0	0	1	-360	360	0	0	0	0	0	0.3	;
	62	259	0.00494	0.02909	0.05136	376	381	381	0	0	1	-360	360	0	0	0	0	0	36.5	;
	62	259	0.00494	0.02910	0.05138	376	381	381	0	0	1	-360	360	0	0	0	0	0	36.5	;
	62	261	0.00436	0.02258	0.03816	370	381	381	0	0	1	-360	360	0	0	0	0	0	27.5	;
	62	309	0.00099	0.00511	0.00864	370	381	381	0	0	1	-360	360	0	0	0	0	0	6.2	;
	62	309	0.00100	0.00533	0.00832	374	381	381	0	0	1	-360	360	0	0	0	0	0	6.2	;
	63	194	0.01182	0.06597	0.09589	374	381	381	0	0	1	-360	360	0	0	0	0	0	74.1	;
	65	257	0.00276	0.01543	0.02230	381	381	381	0	0	1	-360	360	0	0	0	0	0	17.3	;
	65	257	0.00274	0.01524	0.02237	381	381	381	0	0	1	-360	360	0	0	0	0	0	17.3	;
	65	259	0.00494	0.02909	0.05136	376	381	381	0	0	1	-360	360	0	0	0	0	0	36.5	;
	65	259	0.00494	0.02910	0.05138	376	381	381	0	0	1	-360	360	0	0	0	0	0	36.5	;
	66	75	0.00643	0.07053	0.19964	762	762	762	0	0	1	-360	360	0	0	0	0	0	111.0	;
	66	218	0.00004	0.00024	0.00036	381	381	381	0	0	1	-360	360	0	0	0	0	0	0.3	;
	71	78	0.01059	0.05809	0.08706	382	400	435	0	0	1	-360	360	0	0	0	0	0	66.3	;
	71	78	0.01059	0.05809	0.08706	382	400	435	0	0	1	-360	360	0	0	0	0	0	66.3	;
	72	261	0.00436	0.02258	0.03816	370	381	381	0	0	1	-360	360	0	0	0	0	0	27.5	;
	72	261	0.00436	0.02258	0.03816	370	381	381	0	0	1	-360	360	0	0	0	0	0	27.5	;
	73	77	0.00728	0.03932	0.06050	374	400	435	0	0	1	-360	360	0	0	0	0	0	45.6	;
	73	77	0.00728	0.03932	0.06050	374	400	435	0	0	1	-360	360	0	0	0	0	0	45.6	;
	73	79	0.00323	0.03461	0.09262	762	762	762	0	0	1	-360	360	0	0	0	0	0	52.6	;
	75	79	0.00198	0.02173	0.06151	762	762	762	0	0	1	-360	360	0	0	0	0	0	34.2	;
	75	267	0.00007	0.00037	0.00060	382	400	435	0	0	1	-360	360	0	0	0	0	0	0.4	;
	77	192	0.00417	0.02316	0.03385	374	400	435	0	0	1	-360	360	0	0	0	0	0	26.1	;
	77	192	0.00415	0.02295	0.03391	374	400	435	0	0	1	-360	360	0	0	0	0	0	26.2	;
	78	223	0.00210	0.01129	0.01767	342	364	402	0	0	1	-360	360	0	0	0	0	0	13.2	;
	78	258	0.00326	0.01810	0.02629	382	400	435	0	0	1	-360	360	0	0	0	0	0	20.3	;
	80	87	0.00110	0.01238	0.32679	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	59.4	;
	80	105	0.00121	0.01319	0.34995	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	64.1	;
	80	314	0.00084	0.00916	0.24295	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	44.5	;
	80	315	0.00189	0.02058	0.54594	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	100.0	;
	81	93	0.00033	0.00354	0.11277	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	18.9	;
	81	94	0.00067	0.00698	0.22053	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	37.0	;
	82	85	0.00129	0.01423	0.39181	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	69.3	;
	82	89	0.00033	0.00337	0.11050	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	18.3	;
	82	100	0.00073	0.00767	0.23726	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	40.2	;
	83	85	0.00102	0.01121	0.31128	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	55.0	;
	83	95	0.00097	0.01070	0.29713	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	52.5	;
	83	99	0.00145	0.01359	0.36483	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	65.9	;
	83	100	0.00148	0.01682	0.44536	1363	1386	1386	0	0	1	-360	360	0	0	0	0	0	80.9	;
	83	101	0.00180	0.02068	0.54758	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	101.5	;
	84	86	0.00052	0.00545	0.17093	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	28.9	;
	84	100	0.00154	0.01688	0.47566	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	83.9	;
	85	89	0.00155	0.01781	0.47277	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	86.0	;
	85	95	0.00156	0.01787	0.47431	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	86.3	;
	85	99	0.00155	0.01683	0.44571	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	81.2	;
	86	87	0.00177	0.01995	0.52618	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	96.0	;
	86	97	0.00029	0.00326	0.08819	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	15.9	;
	86	226	0.00087	0.01001	0.27166	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	48.1	;
	87	102	0.00188	0.01980	0.56096	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	97.8	;
	87	226	0.00087	0.01001	0.27166	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	48.1	;
	88	93	0.00054	0.00612	0.16169	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	29.4	;
	88	93	0.00060	0.00719	0.18512	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	34.1	;
	88	96	0.00110	0.01246	0.32750	1631	1711	1856	0	0	1	-360	360	0	0	0	0	0	59.6	;
	88	104	0.00039	0.00442	0.11663	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	21.2	;
	89	97	0.00098	0.01097	0.30363	1321	1386	1386	0	0	1	-360	360	0	0	0	0	0	53.6	;
	89	100	0.00045	0.00479	0.14279	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	24.6	;
	89	226	0.00172	0.01783	0.57194	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	94.6	;
	89	315	0.00152	0.01616	0.48177	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	83.0	;
	89	315	0.00152	0.01616	0.48177	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	83.0	;
	90	93	0.00140	0.01450	0.44012	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	74.8	;
	90	103	0.00130	0.01145	0.38503	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	61.9	;
	90	103	0.00130	0.01145	0.38503	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	61.9	;
	90	268	0.00029	0.00313	0.08865	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	15.4	;
	90	310	0.00081	0.00883	0.24845	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	43.8	;
	90	311	0.00022	0.00248	0.06641	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	12.0	;
	91	104	0.00058	0.00534	0.23072	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	33.0	;
	91	104	0.00055	0.00578	0.21834	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	33.5	;
	91	229	0.00006	0.00064	0.01773	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	3.2	;
	91	229	0.00003	0.00034	0.00976	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	3.1	;
	91	230	0.00012	0.00131	0.03755	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	6.6	;
	92	93	0.00042	0.00475	0.12571	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	23.3	;
	92	95	0.00203	0.02300	0.61990	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	111.8	;
	92	317	0.00183	0.02078	0.56002	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	101.0	;
	92	317	0.00183	0.02078	0.56002	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	101.0	;
	93	94	0.00083	0.00877	0.26932	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	46.4	;
	93	101	0.00154	0.01769	0.46841	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	85.3	;
	94	312	0.00091	0.00943	0.29801	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	50.0	;
	95	101	0.00118	0.01226	0.38323	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	63.7	;
	95	241	0.00023	0.00238	0.07551	528	528	528	0	0	1	-360	360	0	0	0	0	0	12.7	;
	95	242	0.00018	0.00203	0.05599	528	528	528	0	0	1	-360	360	0	0	0	0	0	9.9	;
	96	104	0.00073	0.00817	0.21485	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	39.1	;
	96	232	0.00000	0.00009	0.00247	350	350	350	0	0	1	-360	360	0	0	0	0	0	0.4	;
	96	233	0.00000	0.00008	0.00236	350	350	350	0	0	1	-360	360	0	0	0	0	0	0.4	;
	96	1	0.00090	0.00952	0.28796	1390	1400	1660	0	0	1	-360	360	0	0	0	0	0	1.1	;
	96	1	0.00090	0.00952	0.28796	1390	1400	1660	0	0	1	-360	360	0	0	0	0	0	1.1	;
	98	99	0.00075	0.00843	0.22418	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	40.9	;
	98	316	0.00163	0.01830	0.48673	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	88.8	;
	98	318	0.00186	0.02092	0.55634	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	101.5	;
	98	3	0.00050	0.00560	0.14990	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	25.7	;
	99	243	0.00000	0.00003	0.00085	505	505	505	0	0	1	-360	360	0	0	0	0	0	0.2	;
	99	244	0.00000	0.00004	0.00112	505	505	505	0	0	1	-360	360	0	0	0	0	0	0.2	;
	99	313	0.00211	0.02370	0.63033	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	115.0	;
	100	239	0.00001	0.00006	0.00189	438	438	438	0	0	1	-360	360	0	0	0	0	0	0.3	;
	100	240	0.00000	0.00005	0.00147	438	438	438	0	0	1	-360	360	0	0	0	0	0	0.2	;
	101	103	0.00135	0.01243	0.34410	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	60.6	;
	101	103	0.00135	0.01243	0.34410	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	60.6	;
	102	107	0.00148	0.01558	0.48416	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	81.3	;
	104	312	0.00069	0.00733	0.22050	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	37.8	;
	105	227	0.00002	0.00025	0.00729	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	1.2	;
	105	228	0.00002	0.00016	0.00490	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	0.8	;
	105	313	0.00138	0.01546	0.41109	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	75.0	;
	105	4	0.00165	0.01585	0.47306	1280	1386	1386	0	0	1	-360	360	0	0	0	0	0	39.9	;
	106	225	0.00054	0.00576	0.17268	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	29.4	;
	106	310	0.00081	0.00883	0.24845	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	43.8	;
	106	317	0.00279	0.03061	0.86181	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	152.0	;
	106	2	0.00014	0.00127	0.03480	1469	1571	1706	0	0	1	-360	360	0	0	0	0	0	4.7	;
	107	314	0.00109	0.01191	0.31610	1361	1386	1386	0	0	1	-360	360	0	0	0	0	0	57.9	;
	107	7	0.00128	0.01156	0.34479	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	33.9	;
	115	269	0.04872	0.13047	0.00658	68.4	95.7	95.7	0	0	1	-360	360	0	0	0	0	0	27.1	;
	116	279	0.00140	0.00618	0.00007	141.9	148.1	148.1	0	0	1	-360	360	0	0	0	0	0	0.7	;
	130	280	0.00764	0.02567	0.00141	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	5.6	;
	130	280	0.00675	0.02267	0.00124	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	4.9	;
	132	283	0.00006	0.00038	0.00000	98.2	105.2	105.2	0	0	1	-360	360	0	0	0	0	0	0.0	;
	145	286	0.00039	0.00130	0.00007	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	0.3	;
	148	172	0.02098	0.07050	0.00097	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	7.6	;
	148	294	0.04434	0.11874	0.00150	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	12.4	;
	165	272	0.03544	0.11907	0.00163	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	12.9	;
	165	298	0.10947	0.36776	0.00504	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	39.8	;
	165	300	0.09382	0.31521	0.00432	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	34.1	;
	167	297	0.00700	0.01875	0.00024	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	2.0	;
	172	304	0.03250	0.10917	0.00150	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	11.8	;
	173	174	0.00209	0.01408	0.00522	274	291	322	0	0	1	-360	360	0	0	0	0	0	8.0	;
	175	176	0.00576	0.01966	0.00632	96	104	104	0	0	1	-360	360	0	0	0	0	0	10.5	;
	180	249	0.00173	0.00907	0.00310	136	162	203	0	0	1	-360	360	0	0	0	0	0	4.5	;
	185	247	0.00468	0.01573	0.00525	171	186	206	0	0	0	-360	360	0	0	0	0	0	8.5	;
	186	247	0.00382	0.01284	0.00428	171	186	206	0	0	1	-360	360	0	0	0	0	0	6.9	;
	190	256	0.00032	0.00165	0.00260	382	400	435	0	0	1	-360	360	0	0	0	0	0	1.9	;
	193	220	0.00037	0.00490	0.01932	1200	1200	1200	0	0	1	-360	360	0	0	0	0	0	9.2	;
	195	258	0.00240	0.01307	0.02007	199	237	297	0	0	1	-360	360	0	0	0	0	0	15.1	;
	208	210	0.00017	0.00165	0.00492	897	941	1021	0	0	1	-360	360	0	0	0	0	0	2.6	;
	209	211	0.00016	0.00164	0.00484	897	941	1021	0	0	1	-360	360	0	0	0	0	0	2.6	;
	212	263	0.00201	0.01066	0.01664	374	381	381	0	0	1	-360	360	0	0	0	0	0	12.5	;
	212	266	0.00001	0.00006	0.00010	374	400	435	0	0	1	-360	360	0	0	0	0	0	0.3	;
	212	309	0.00100	0.00533	0.00832	374	381	381	0	0	1	-360	360	0	0	0	0	0	6.2	;
	220	221	0.00003	0.00043	0.00171	1204	1279	1416	0	0	1	-360	360	0	0	0	0	0	0.8	;
	223	262	0.00210	0.01129	0.01767	342	364	402	0	0	1	-360	360	0	0	0	0	0	13.2	;
	223	265	0.00001	0.00007	0.00011	382	400	435	0	0	1	-360	360	0	0	0	0	0	0.1	;
	224	264	0.00058	0.00305	0.00481	382	400	435	0	0	1	-360	360	0	0	0	0	0	3.6	;
	231	311	0.00050	0.00576	0.15386	1631	1711	1857	0	0	1	-360	360	0	0	0	0	0	27.8	;
	261	309	0.00337	0.01746	0.02953	370	381	381	0	0	1	-360	360	0	0	0	0	0	21.3	;
	269	270	0.00018	0.00048	0.00002	68.4	95.7	95.7	0	0	1	-360	360	0	0	0	0	0	0.1	;
	270	271	0.03024	0.10158	0.00139	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	11.0	;
	271	272	0.06361	0.21371	0.00293	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	23.1	;
	273	274	0.00201	0.00675	0.00009	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	0.7	;
	273	282	0.00182	0.00803	0.00009	141.9	148.1	148.1	0	0	1	-360	360	0	0	0	0	0	0.9	;
	274	275	0.00281	0.00944	0.00013	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	1.0	;
	275	276	0.02600	0.08734	0.00479	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	18.9	;
	276	277	0.00138	0.00609	0.00007	141.9	148.1	148.1	0	0	1	-360	360	0	0	0	0	0	0.7	;
	277	278	0.00441	0.01480	0.00020	39.9	56.5	56.5	0	0	1	-360	360	0	0	0	0	0	1.6	;
	278	279	0.00903	0.03035	0.00166	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	6.6	;
	280	281	0.00538	0.01809	0.00099	126	142.6	142.6	0	0	1	-360	360	0	0	0	0	0	3.9	;
	281	282	0.00356	0.01569	0.00017	141.9	148.1	148.1	0	0	1	-360	360	0	0	0	0	0	1.7	;
	283	284	0.01858	0.08318	0.00442	89.5	127.8	127.8	0	0	1	-360	360	0	0	0	0	0	18.1	;
	284	285	0.00040	0.00134	0.00007	79.9	113.2	113.2	0	0	1	-360	360	0	0	0	0	0	0.3	;
	285	286	0.00640	0.02868	0.00152	89.5	127.8	127.8	0	0	1	-360	360	0	0	0	0	0	6.2	;
	287	288	0.00001	0.00008	0.00004	260	273	296	0	0	1	-360	360	0	0	0	0	0	0.1	;
	287	289	0.00080	0.00550	0.00257	260	273	296	0	0	1	-360	360	0	0	0	0	0	3.5	;
	289	290	0.00073	0.00503	0.00235	260	273	296	0	0	1	-360	360	0	0	0	0	0	3.2	;
	290	291	0.00023	0.00158	0.00074	260	273	296	0	0	1	-360	360	0	0	0	0	0	1.0	;
	291	292	0.00003	0.00024	0.00011	260	273	296	0	0	1	-360	360	0	0	0	0	0	0.2	;
	292	293	0.00352	0.00995	0.25805	200	200	200	0	0	1	-360	360	0	0	0	0	0	18.0	;
	294	295	0.05723	0.15326	0.00193	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	15.9	;
	295	296	0.01177	0.03051	0.00039	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	3.3	;
	296	297	0.00413	0.01106	0.00014	34.2	47.8	47.8	0	0	1	-360	360	0	0	0	0	0	1.2	;
	298	299	0.00022	0.00074	0.00001	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	0.1	;
	299	300	0.00065	0.00224	0.00307	75.3	93.4	93.4	0	0	1	-360	360	0	0	0	0	0	0.9	;
	299	301	0.04932	0.16570	0.00227	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	17.9	;
	301	302	0.04635	0.15571	0.00213	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	16.8	;
	302	303	0.05326	0.17893	0.00245	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	19.3	;
	303	304	0.00006	0.00019	0.00000	63	71.3	71.3	0	0	1	-360	360	0	0	0	0	0	0.0	;
	306	307	0.00069	0.00352	0.00131	255	260	260	0	0	1	-360	360	0	0	0	0	0	2.0	;
	310	318	0.00239	0.02618	0.73707	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	130.0	;
	312	305	0.00149	0.01430	0.42682	1280	1386	1386	0	0	1	-360	360	0	0	0	0	0	36.0	;
	313	315	0.00119	0.01340	0.35628	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	65.0	;
	313	316	0.00095	0.01070	0.28447	1386	1386	1386	0	0	1	-360	360	0	0	0	0	0	51.9	;
	8	36	0.00068	0.00636	0.00000	250	250	250	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	8	109	0.00164	0.09698	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	9	112	0.00217	0.09340	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	9	112	0.00225	0.09479	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	9	112	0.00233	0.09763	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	9	112	0.00318	0.10011	0.00000	120	120	120	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	10	80	0.00089	0.04787	0.00000	250	250	250	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	10	80	0.00089	0.04771	0.00000	250	250	250	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	10	113	0.00174	0.10334	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	10	113	0.00733	0.16386	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	10	113	0.00232	0.09633	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	11	117	0.00214	0.10048	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	11	117	0.00238	0.09587	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	12	121	0.00190	0.07474	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	12	121	0.00220	0.09913	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	12	121	0.00616	0.16343	0.00000	63	63	63	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	12	121	0.00222	0.10167	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	13	84	0.00042	0.02753	0.00000	450	450	450	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	13	123	0.00311	0.09582	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	13	123	0.00286	0.09329	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	13	123	0.00225	0.09711	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	13	123	0.00236	0.09720	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	14	86	0.00043	0.02838	0.00000	450	450	450	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	14	86	0.00043	0.02841	0.00000	450	450	450	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	15	87	0.00054	0.03452	0.00000	360	360	360	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	15	87	0.00056	0.03403	0.00000	360	360	360	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	15	126	0.00373	0.03262	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	15	126	0.00311	0.09643	0.00000	120	120	120	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	15	126	0.00314	0.09606	0.00000	120	120	120	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	16	47	0.00210	0.08795	0.00000	80	80	80	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	17	88	0.00060	0.04458	0.00000	360	360	360	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	17	88	0.00060	0.04458	0.00000	360	360	360	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	17	128	0.00306	0.09450	0.00000	120	120	120	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	17	128	0.00288	0.09556	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	18	133	0.00176	0.09245	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	18	133	0.00307	0.09449	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	18	133	0.00310	0.09450	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	19	140	0.00667	0.15983	0.00000	63	63	63	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	19	140	0.00846	0.19132	0.00000	63	63	63	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	20	141	0.00175	0.09486	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	20	141	0.00174	0.09564	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	21	142	0.00174	0.10334	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	21	142	0.00175	0.09398	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	22	146	0.00183	0.09857	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	22	146	0.00183	0.09857	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	23	149	0.00219	0.09343	0.00000	126	126	126	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	23	149	0.00217	0.09495	0.00000	126	126	126	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	23	149	0.00283	0.09606	0.00000	126	126	126	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	24	98	0.00042	0.04200	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	24	98	0.00042	0.04111	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	24	150	0.00783	0.13894	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	24	150	0.00835	0.18356	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	24	150	0.00783	0.13894	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	25	151	0.00225	0.10061	0.00000	126	126	126	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	25	151	0.00239	0.09656	0.00000	126	126	126	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	25	151	0.00174	0.09398	0.00000	170	170	170	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	29	102	0.00043	0.03488	0.00000	450	450	450	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	29	159	0.00172	0.09187	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	29	159	0.00185	0.09620	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	31	72	0.00050	0.04040	0.00000	250	250	250	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	31	72	0.00068	0.04048	0.00000	250	250	250	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	31	162	0.00502	0.16181	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	31	162	0.00255	0.09687	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	32	104	0.00042	0.04111	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	32	104	0.00042	0.04111	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	32	108	0.00000	0.11643	0.00000	140	140	140	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	33	163	0.00175	0.09562	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	33	163	0.00169	0.09567	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	34	107	0.00044	0.03478	0.00000	450	450	450	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	34	107	0.00076	0.03467	0.00000	450	450	450	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	34	169	0.00251	0.09728	0.00000	126	126	126	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	34	169	0.00254	0.09799	0.00000	126	126	126	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	36	109	0.00177	0.09261	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	36	109	0.00153	0.09406	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	37	110	0.00172	0.08920	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	37	110	0.00174	0.08968	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	37	110	0.00159	0.10202	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	38	111	0.00185	0.10291	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	38	111	0.00184	0.10291	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	38	111	0.00185	0.10302	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	39	114	0.00189	0.10381	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	39	114	0.00189	0.10381	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	39	114	0.00246	0.09660	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	40	115	0.00308	0.08194	0.00000	120	120	120	1.025000000	0	1	-360	360	0.0042	19	1	25	13	0	;
	40	115	0.00175	0.09833	0.00000	126	126	126	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	41	81	0.00038	0.03554	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	41	81	0.00035	0.03570	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	41	116	0.00182	0.10291	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	41	116	0.00186	0.10476	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	42	118	0.00226	0.08947	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	42	118	0.00667	0.17937	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	42	118	0.00687	0.18424	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	42	118	0.00260	0.09610	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	43	82	0.00035	0.02646	0.00000	450	450	450	0.970833333	0	1	-360	360	0.0042	6	1	25	13	0	;
	43	82	0.00034	0.03561	0.00000	450	450	450	0.970833333	0	1	-360	360	0.0042	6	1	25	13	0	;
	43	119	0.00159	0.10273	0.00000	170	170	170	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	44	120	0.00159	0.10440	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	44	120	0.00303	0.08938	0.00000	126	126	126	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	44	120	0.00213	0.09363	0.00000	126	126	126	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	44	120	0.00235	0.09467	0.00000	126	126	126	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	45	85	0.00041	0.02771	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	45	85	0.00042	0.02792	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	45	124	0.00243	0.09735	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	45	124	0.00088	0.02459	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	45	124	0.00206	0.09777	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	46	125	0.00159	0.10729	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	46	125	0.00159	0.10729	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	46	125	0.00159	0.10729	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	47	127	0.00161	0.10741	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	47	127	0.00161	0.10741	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	47	127	0.00161	0.10741	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	48	129	0.00262	0.09303	0.00000	120	120	120	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	48	129	0.00301	0.08939	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	48	129	0.00193	0.10811	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	49	130	0.00222	0.09429	0.00000	120	120	120	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	49	130	0.00248	0.09324	0.00000	120	120	120	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	49	130	0.00261	0.09491	0.00000	120	120	120	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	49	130	0.00230	0.09420	0.00000	126	126	126	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	50	89	0.00035	0.03542	0.00000	450	450	450	0.966666667	0	1	-360	360	0.0042	5	1	25	13	0	;
	50	89	0.00040	0.02611	0.00000	450	450	450	0.970833333	0	1	-360	360	0.0042	6	1	25	13	0	;
	50	89	0.00040	0.02685	0.00000	450	450	450	0.970833333	0	1	-360	360	0.0042	6	1	25	13	0	;
	51	90	0.00035	0.03542	0.00000	450	450	450	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	52	132	0.00258	0.09514	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	53	134	0.00181	0.10383	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	53	134	0.00220	0.09305	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	53	134	0.00186	0.10429	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	55	135	0.00174	0.07004	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	55	135	0.00313	0.09828	0.00000	120	120	120	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	55	135	0.00318	0.09619	0.00000	120	120	120	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	55	135	0.00148	0.10157	0.00000	170	170	170	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	56	136	0.00169	0.08935	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	56	136	0.00168	0.08989	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	56	136	0.00172	0.08913	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	57	93	0.00037	0.02604	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	57	93	0.00036	0.02624	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	57	138	0.00279	0.09137	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	57	138	0.00182	0.10337	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	57	138	0.00088	0.02459	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	58	139	0.00174	0.08924	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	58	139	0.00172	0.08954	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	58	139	0.00167	0.08815	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	59	143	0.00166	0.11001	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	59	143	0.00165	0.11008	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	60	144	0.00186	0.10425	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	60	144	0.00229	0.09421	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	62	152	0.00190	0.09563	0.00000	126	126	126	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	62	152	0.00238	0.09541	0.00000	126	126	126	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	62	152	0.00690	0.18513	0.00000	63	63	63	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	63	153	0.00492	0.18032	0.00000	63	63	63	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	63	153	0.00690	0.18424	0.00000	63	63	63	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	64	154	0.00235	0.09390	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	64	154	0.00208	0.09320	0.00000	126	126	126	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	65	155	0.00238	0.11984	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	65	155	0.00208	0.09683	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	65	155	0.00206	0.09841	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	66	156	0.00224	0.09526	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	66	156	0.00164	0.09720	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	68	157	0.00185	0.10818	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	68	157	0.00182	0.10768	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	69	101	0.00035	0.03524	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	71	161	0.00224	0.09615	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	71	161	0.00161	0.10130	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	73	165	0.00228	0.09986	0.00000	126	126	126	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	73	165	0.00207	0.09444	0.00000	126	126	126	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	74	166	0.00161	0.10116	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	74	166	0.00161	0.10168	0.00000	170	170	170	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	75	167	0.00188	0.10349	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	75	167	0.00188	0.10349	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	75	167	0.00309	0.08174	0.00000	120	120	120	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	76	168	0.00189	0.10744	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	76	168	0.00186	0.10639	0.00000	170	170	170	0.983333333	0	1	-360	360	0.0042	9	1	25	13	0	;
	76	168	0.00206	0.01435	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	77	106	0.00035	0.03589	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	77	106	0.00035	0.03542	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	77	106	0.00035	0.03598	0.00000	450	450	450	0.987500000	0	1	-360	360	0.0042	10	1	25	13	0	;
	78	170	0.00238	0.09841	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	78	170	0.00229	0.09655	0.00000	126	126	126	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	79	172	0.00230	0.09955	0.00000	126	126	126	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	79	172	0.00236	0.09390	0.00000	126	126	126	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	81	116	0.00182	0.09659	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	81	116	0.00182	0.09641	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	82	119	0.00149	0.09225	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	82	119	0.00151	0.09331	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	82	119	0.00154	0.09267	0.00000	170	170	170	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	83	122	0.00149	0.09236	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	83	122	0.00150	0.09173	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	83	122	0.00151	0.09236	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	88	128	0.00203	0.09550	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	88	128	0.00204	0.09549	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	89	131	0.00151	0.09236	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	89	131	0.00151	0.09278	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	89	131	0.00204	0.09549	0.00000	170	170	170	1.004166667	0	1	-360	360	0.0042	14	1	25	13	0	;
	92	137	0.00150	0.09236	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	92	137	0.00154	0.09277	0.00000	170	170	170	1.000000000	0	1	-360	360	0.0042	13	1	25	13	0	;
	94	319	0.00082	0.02035	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	94	319	0.00082	0.02035	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	95	145	0.00082	0.02035	0.00000	170	170	170	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
	95	145	0.00155	0.09267	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	95	145	0.00211	0.09517	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	97	147	0.00200	0.09776	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	97	147	0.00200	0.09776	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	101	158	0.00151	0.09236	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	101	158	0.00153	0.09299	0.00000	170	170	170	1.008333333	0	1	-360	360	0.0042	15	1	25	13	0	;
	103	160	0.00153	0.09299	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	103	160	0.00151	0.09267	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	105	164	0.00182	0.08988	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	105	164	0.00184	0.09109	0.00000	170	170	170	1.012500000	0	1	-360	360	0.0042	16	1	25	13	0	;
	171	316	0.00082	0.02035	0.00000	170	170	170	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	171	316	0.00082	0.02035	0.00000	170	170	170	0.979166667	0	1	-360	360	0.0042	8	1	25	13	0	;
	306	312	0.00076	0.03467	0.00000	450	450	450	0.991666667	0	1	-360	360	0.0042	11	1	25	13	0	;
	309	318	0.00038	0.03554	0.00000	450	450	450	0.995833333	0	1	-360	360	0.0042	12	1	25	13	0	;
	313	320	0.00082	0.02035	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	313	320	0.00082	0.02035	0.00000	170	170	170	1.016666667	0	1	-360	360	0.0042	17	1	25	13	0	;
	315	321	0.00082	0.02035	0.00000	170	170	170	1.020833333	0	1	-360	360	0.0042	18	1	25	13	0	;
];
